/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.NettyWebSocketSessionSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyWebSocketSession
extends NettyWebSocketSessionSupport<WebSocketConnection> {
    public ReactorNettyWebSocketSession(WebsocketInbound inbound, WebsocketOutbound outbound, HandshakeInfo info, NettyDataBufferFactory bufferFactory) {
        super(new WebSocketConnection(inbound, outbound), info, bufferFactory);
    }

    @Override
    public Flux<WebSocketMessage> receive() {
        return ((WebSocketConnection)this.getDelegate()).getInbound().aggregateFrames(65536).receiveFrames().map(x$0 -> super.toMessage((WebSocketFrame)x$0));
    }

    @Override
    public Mono<Void> send(Publisher<WebSocketMessage> messages) {
        Flux frames = Flux.from(messages).map(this::toFrame);
        return ((WebSocketConnection)this.getDelegate()).getOutbound().options(NettyPipeline.SendOptions::flushOnEach).sendObject((Publisher)frames).then();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        return Mono.error((Throwable)new UnsupportedOperationException("Currently in Reactor Netty applications are expected to use the Cancellation returned from subscribing to the \"receive\"-side Flux in order to close the WebSocket session."));
    }

    public static class WebSocketConnection {
        private final WebsocketInbound inbound;
        private final WebsocketOutbound outbound;

        public WebSocketConnection(WebsocketInbound inbound, WebsocketOutbound outbound) {
            this.inbound = inbound;
            this.outbound = outbound;
        }

        public WebsocketInbound getInbound() {
            return this.inbound;
        }

        public WebsocketOutbound getOutbound() {
            return this.outbound;
        }
    }
}

