/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import org.springframework.core.NestedRuntimeException;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.ResponseInstruction;

public abstract class ResponseInstructionHandler {
    private Object result;

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public final ResponseInstructionHandler handle(ResponseInstruction responseInstruction) throws Exception {
        if (responseInstruction.isApplicationView()) {
            this.handleApplicationView((ApplicationView)responseInstruction.getViewSelection());
        } else if (responseInstruction.isFlowDefinitionRedirect()) {
            this.handleFlowDefinitionRedirect((FlowDefinitionRedirect)responseInstruction.getViewSelection());
        } else if (responseInstruction.isFlowExecutionRedirect()) {
            this.handleFlowExecutionRedirect((FlowExecutionRedirect)responseInstruction.getViewSelection());
        } else if (responseInstruction.isExternalRedirect()) {
            this.handleExternalRedirect((ExternalRedirect)responseInstruction.getViewSelection());
        } else if (responseInstruction.isNull()) {
            this.handleNull();
        } else {
            throw new IllegalArgumentException("Don't know how to handle response instruction " + responseInstruction);
        }
        return this;
    }

    public final ResponseInstructionHandler handleQuietly(ResponseInstruction responseInstruction) {
        try {
            return this.handle(responseInstruction);
        }
        catch (Exception e) {
            throw new RuntimeResponseHandlingException("Unexpected exception handling response instruction " + responseInstruction + "", e);
        }
    }

    protected abstract void handleApplicationView(ApplicationView var1) throws Exception;

    protected abstract void handleFlowDefinitionRedirect(FlowDefinitionRedirect var1) throws Exception;

    protected abstract void handleFlowExecutionRedirect(FlowExecutionRedirect var1) throws Exception;

    protected abstract void handleExternalRedirect(ExternalRedirect var1) throws Exception;

    protected abstract void handleNull() throws Exception;

    public static class RuntimeResponseHandlingException
    extends NestedRuntimeException {
        public RuntimeResponseHandlingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

