/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletResponseHeadersAdapter;
import org.springframework.util.Assert;

public class ServletServerHttpResponse
implements ServerHttpResponse {
    private final HttpServletResponse servletResponse;
    private final HttpHeaders headers;
    private boolean headersWritten = false;
    private boolean bodyUsed = false;
    private @Nullable HttpHeaders readOnlyHeaders;

    public ServletServerHttpResponse(HttpServletResponse servletResponse) {
        Assert.notNull((Object)servletResponse, (String)"HttpServletResponse must not be null");
        this.servletResponse = servletResponse;
        this.headers = new HttpHeaders(new ServletResponseHeadersAdapter(servletResponse));
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    @Override
    public void setStatusCode(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode must not be null");
        this.servletResponse.setStatus(status.value());
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (this.headersWritten) {
            this.readOnlyHeaders = HttpHeaders.readOnlyHttpHeaders(this.headers);
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    @Override
    public OutputStream getBody() throws IOException {
        this.bodyUsed = true;
        this.writeHeaders();
        return this.servletResponse.getOutputStream();
    }

    @Override
    public void flush() throws IOException {
        this.writeHeaders();
        if (this.bodyUsed) {
            this.servletResponse.flushBuffer();
        }
    }

    @Override
    public void close() {
        this.writeHeaders();
    }

    private void writeHeaders() {
        if (!this.headersWritten) {
            if (this.servletResponse.getContentType() == null && this.headers.containsHeader("Content-Type")) {
                this.servletResponse.setContentType(this.headers.getFirst("Content-Type"));
            }
            if (this.servletResponse.getCharacterEncoding() == null && this.headers.containsHeader("Content-Type")) {
                try {
                    Charset charset;
                    MediaType contentType = this.headers.getContentType();
                    if (contentType != null && (charset = contentType.getCharset()) != null) {
                        this.servletResponse.setCharacterEncoding(charset);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.headersWritten = true;
        }
    }
}

