/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.http.HttpServletResponse;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class ServletResponseHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpServletResponse response;

    ServletResponseHeadersAdapter(HttpServletResponse response) {
        this.response = response;
    }

    public @Nullable String getFirst(String key) {
        String header = this.response.getHeader(key);
        if (header == null && key.equalsIgnoreCase("Content-Type")) {
            header = this.response.getContentType();
        }
        return header;
    }

    public void add(String key, @Nullable String value) {
        this.response.addHeader(key, value);
    }

    public void addAll(String key, List<? extends String> values) {
        for (String string : values) {
            this.response.addHeader(key, string);
        }
    }

    public void addAll(MultiValueMap<String, String> map) {
        throw ServletResponseHeadersAdapter.httpHeadersUnsupportedOperationException();
    }

    public void set(String key, @Nullable String value) {
        this.response.setHeader(key, value);
    }

    public void setAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Collection names = this.response.getHeaderNames();
        for (String name : names) {
            map.put(name, this.response.getHeader(name));
        }
        return map;
    }

    public int size() {
        return this.response.getHeaderNames().size();
    }

    public boolean isEmpty() {
        return this.response.getHeaderNames().isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            return this.response.containsHeader(headerName);
        }
        return false;
    }

    public boolean containsValue(Object rawValue) {
        throw ServletResponseHeadersAdapter.httpHeadersUnsupportedOperationException();
    }

    public @Nullable List<String> get(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Collection values = this.response.getHeaders(headerName);
            if (values.isEmpty() && headerName.equalsIgnoreCase("Content-Type")) {
                String contentType = this.response.getContentType();
                return contentType != null ? Collections.singletonList(contentType) : null;
            }
            if (!values.isEmpty()) {
                return new ArrayList<String>(values);
            }
        }
        return null;
    }

    public @Nullable List<String> put(String key, List<String> values) {
        Object previous = this.remove(key);
        for (String value : values) {
            this.response.addHeader(key, value);
        }
        return previous;
    }

    public @Nullable List<String> remove(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Object previous = this.get(headerName);
            if (previous != null) {
                this.response.setHeader(headerName, null);
            }
            return previous;
        }
        return null;
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        throw ServletResponseHeadersAdapter.httpHeadersUnsupportedOperationException();
    }

    public void clear() {
        for (String headerName : this.response.getHeaderNames()) {
            this.response.setHeader(headerName, null);
        }
    }

    public Set<String> keySet() {
        return new HeaderNames();
    }

    public Collection<List<String>> values() {
        throw ServletResponseHeadersAdapter.httpHeadersUnsupportedOperationException();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        throw ServletResponseHeadersAdapter.httpHeadersUnsupportedOperationException();
    }

    private static UnsupportedOperationException httpHeadersUnsupportedOperationException() {
        return new UnsupportedOperationException("HttpHeaders does not support all Map operations");
    }

    public int hashCode() {
        return this.toMultiValueMap().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MultiValueMap)) return false;
        MultiValueMap that = (MultiValueMap)other;
        if (!this.toMultiValueMap().equals((Object)that)) return false;
        return true;
    }

    private MultiValueMap<String, String> toMultiValueMap() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String name : this.response.getHeaderNames()) {
            for (String value : this.response.getHeaders(name)) {
                map.add((Object)name, (Object)value);
            }
        }
        return map;
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(ServletResponseHeadersAdapter.this.response.getHeaderNames());
        }

        @Override
        public int size() {
            return ServletResponseHeadersAdapter.this.size();
        }
    }

    private static final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> values;

        private HeaderNamesIterator(Collection<String> values) {
            this.values = values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.values.hasNext();
        }

        @Override
        public String next() {
            return this.values.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

