/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.registry.GroupsMetadata;
import org.springframework.web.service.registry.HttpServiceClient;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;
import org.springframework.web.service.registry.HttpServiceProxyRegistryFactoryBean;

public abstract class AbstractHttpServiceRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware,
BeanFactoryAware,
BeanClassLoaderAware {
    public static final String HTTP_SERVICE_PROXY_REGISTRY_BEAN_NAME = "httpServiceProxyRegistry";
    static final String HTTP_SERVICE_GROUP_NAME_ATTRIBUTE = "httpServiceGroupName";
    private HttpServiceGroup.ClientType defaultClientType = HttpServiceGroup.ClientType.UNSPECIFIED;
    private @Nullable Environment environment;
    private @Nullable ResourceLoader resourceLoader;
    private @Nullable BeanFactory beanFactory;
    private @Nullable ClassLoader beanClassLoader;
    private final GroupsMetadata groupsMetadata = new GroupsMetadata();
    private @Nullable ClassPathScanningCandidateComponentProvider scanner;

    public void setDefaultClientType(HttpServiceGroup.ClientType defaultClientType) {
        this.defaultClientType = defaultClientType;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public final void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
        this.registerBeanDefinitions(metadata, registry);
    }

    public final void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry beanRegistry) {
        this.registerHttpServices(new DefaultGroupRegistry(), metadata);
        if (this.groupsMetadata.isEmpty()) {
            return;
        }
        RootBeanDefinition proxyRegistryBeanDef = this.createOrGetRegistry(beanRegistry);
        this.mergeGroups(proxyRegistryBeanDef);
        this.groupsMetadata.forEachRegistration((groupName, types) -> types.forEach(type -> {
            RootBeanDefinition proxyBeanDef = new RootBeanDefinition();
            proxyBeanDef.setBeanClassName(type);
            proxyBeanDef.setAttribute(HTTP_SERVICE_GROUP_NAME_ATTRIBUTE, groupName);
            proxyBeanDef.setInstanceSupplier(() -> this.getProxyInstance((String)groupName, (String)type));
            String beanName = groupName + "#" + type;
            if (!beanRegistry.containsBeanDefinition(beanName)) {
                beanRegistry.registerBeanDefinition(beanName, (BeanDefinition)proxyBeanDef);
            }
        }));
    }

    protected abstract void registerHttpServices(GroupRegistry var1, AnnotationMetadata var2);

    private RootBeanDefinition createOrGetRegistry(BeanDefinitionRegistry beanRegistry) {
        if (!beanRegistry.containsBeanDefinition(HTTP_SERVICE_PROXY_REGISTRY_BEAN_NAME)) {
            RootBeanDefinition proxyRegistryBeanDef = new RootBeanDefinition();
            proxyRegistryBeanDef.setBeanClass(HttpServiceProxyRegistryFactoryBean.class);
            ConstructorArgumentValues args = proxyRegistryBeanDef.getConstructorArgumentValues();
            args.addIndexedArgumentValue(0, (Object)new GroupsMetadata());
            beanRegistry.registerBeanDefinition(HTTP_SERVICE_PROXY_REGISTRY_BEAN_NAME, (BeanDefinition)proxyRegistryBeanDef);
            return proxyRegistryBeanDef;
        }
        return (RootBeanDefinition)beanRegistry.getBeanDefinition(HTTP_SERVICE_PROXY_REGISTRY_BEAN_NAME);
    }

    private void mergeGroups(RootBeanDefinition proxyRegistryBeanDef) {
        ConstructorArgumentValues args = proxyRegistryBeanDef.getConstructorArgumentValues();
        ConstructorArgumentValues.ValueHolder valueHolder = args.getArgumentValue(0, GroupsMetadata.class);
        Assert.state((valueHolder != null ? 1 : 0) != 0, (String)"Expected GroupsMetadata constructor argument at index 0");
        GroupsMetadata target = (GroupsMetadata)valueHolder.getValue();
        Assert.state((target != null ? 1 : 0) != 0, (String)"No constructor argument value");
        target.mergeWith(this.groupsMetadata);
    }

    private Object getProxyInstance(String groupName, String httpServiceType) {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory has not been set");
        HttpServiceProxyRegistry registry = (HttpServiceProxyRegistry)this.beanFactory.getBean(HTTP_SERVICE_PROXY_REGISTRY_BEAN_NAME, HttpServiceProxyRegistry.class);
        return registry.getClient(groupName, ClassUtils.resolveClassName((String)httpServiceType, (ClassLoader)this.beanClassLoader));
    }

    protected Stream<BeanDefinition> findHttpServices(String basePackage) {
        if (this.scanner == null) {
            Assert.state((this.environment != null ? 1 : 0) != 0, (String)"Environment has not been set");
            Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"ResourceLoader has not been set");
            this.scanner = new HttpExchangeClassPathScanningCandidateComponentProvider();
            this.scanner.setEnvironment(this.environment);
            this.scanner.setResourceLoader(this.resourceLoader);
        }
        return this.scanner.findCandidateComponents(basePackage).stream();
    }

    private class DefaultGroupRegistry
    implements GroupRegistry {
        private DefaultGroupRegistry() {
        }

        @Override
        public GroupRegistry.GroupSpec forGroup(String name, HttpServiceGroup.ClientType clientType) {
            return new DefaultGroupSpec(name, clientType);
        }

        private class DefaultGroupSpec
        implements GroupRegistry.GroupSpec {
            private final GroupsMetadata.Registration registration;

            DefaultGroupSpec(String groupName, HttpServiceGroup.ClientType clientType) {
                clientType = clientType != HttpServiceGroup.ClientType.UNSPECIFIED ? clientType : AbstractHttpServiceRegistrar.this.defaultClientType;
                this.registration = AbstractHttpServiceRegistrar.this.groupsMetadata.getOrCreateGroup(groupName, clientType);
            }

            @Override
            public GroupRegistry.GroupSpec register(Class<?> ... serviceTypes) {
                Arrays.stream(serviceTypes).map(Class::getName).forEach(this::registerServiceTypeName);
                return this;
            }

            @Override
            public GroupRegistry.GroupSpec registerTypeNames(String ... serviceTypes) {
                Arrays.stream(serviceTypes).forEach(this::registerServiceTypeName);
                return this;
            }

            @Override
            public GroupRegistry.GroupSpec detectInBasePackages(Class<?> ... packageClasses) {
                Arrays.stream(packageClasses).map(Class::getPackageName).forEach(this::detectInBasePackage);
                return this;
            }

            @Override
            public GroupRegistry.GroupSpec detectInBasePackages(String ... packageNames) {
                Arrays.stream(packageNames).forEach(this::detectInBasePackage);
                return this;
            }

            private void detectInBasePackage(String packageName) {
                AbstractHttpServiceRegistrar.this.findHttpServices(packageName).filter(DefaultGroupSpec::isNotHttpServiceClientAnnotated).map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).forEach(this::registerServiceTypeName);
            }

            private static boolean isNotHttpServiceClientAnnotated(BeanDefinition defintion) {
                if (defintion instanceof AnnotatedBeanDefinition) {
                    AnnotatedBeanDefinition abd = (AnnotatedBeanDefinition)defintion;
                    return !abd.getMetadata().hasAnnotation(HttpServiceClient.class.getName());
                }
                return true;
            }

            private void registerServiceTypeName(String httpServiceTypeName) {
                this.registration.httpServiceTypeNames().add(httpServiceTypeName);
            }
        }
    }

    protected static interface GroupRegistry {
        default public GroupSpec forGroup(String name) {
            return this.forGroup(name, HttpServiceGroup.ClientType.UNSPECIFIED);
        }

        public GroupSpec forGroup(String var1, HttpServiceGroup.ClientType var2);

        default public GroupSpec forDefaultGroup() {
            return this.forGroup("default");
        }

        public static interface GroupSpec {
            public GroupSpec register(Class<?> ... var1);

            public GroupSpec registerTypeNames(String ... var1);

            public GroupSpec detectInBasePackages(Class<?> ... var1);

            public GroupSpec detectInBasePackages(String ... var1);
        }
    }

    private static class HttpExchangeClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public HttpExchangeClassPathScanningCandidateComponentProvider() {
            this.addIncludeFilter((TypeFilter)new HttpExchangeFilter());
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            AnnotationMetadata metadata = beanDefinition.getMetadata();
            return metadata.isIndependent() && !metadata.isAnnotation();
        }

        private static class HttpExchangeFilter
        extends AnnotationTypeFilter {
            public HttpExchangeFilter() {
                super(HttpExchange.class, true, true);
            }

            protected boolean matchSelf(MetadataReader metadataReader) {
                if (metadataReader.getClassMetadata().isInterface()) {
                    for (MethodMetadata metadata : metadataReader.getAnnotationMetadata().getDeclaredMethods()) {
                        if (!metadata.getAnnotations().isPresent(HttpExchange.class)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

