/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.service.registry.AbstractHttpServiceRegistrar;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.ImportHttpServices;

class AnnotationHttpServiceRegistrar
extends AbstractHttpServiceRegistrar {
    AnnotationHttpServiceRegistrar() {
    }

    @Override
    protected void registerHttpServices(AbstractHttpServiceRegistrar.GroupRegistry registry, AnnotationMetadata metadata) {
        MergedAnnotation groupsAnnot = metadata.getAnnotations().get(ImportHttpServices.Container.class);
        if (groupsAnnot.isPresent()) {
            for (MergedAnnotation annot2 : groupsAnnot.getAnnotationArray("value", ImportHttpServices.class)) {
                this.processImportAnnotation(annot2, registry);
            }
        }
        metadata.getAnnotations().stream(ImportHttpServices.class).forEach(annot -> this.processImportAnnotation((MergedAnnotation<?>)annot, registry));
    }

    private void processImportAnnotation(MergedAnnotation<?> annotation, AbstractHttpServiceRegistrar.GroupRegistry groupRegistry) {
        String groupName = annotation.getString("group");
        HttpServiceGroup.ClientType clientType = (HttpServiceGroup.ClientType)annotation.getEnum("clientType", HttpServiceGroup.ClientType.class);
        groupRegistry.forGroup(groupName, clientType).register(annotation.getClassArray("types")).detectInBasePackages(annotation.getStringArray("basePackages")).detectInBasePackages(annotation.getClassArray("basePackageClasses"));
    }
}

