/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.googlecode.protobuf.format.HtmlFormat;
import com.googlecode.protobuf.format.JsonFormat;
import com.googlecode.protobuf.format.XmlFormat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.protobuf.ExtensionRegistryInitializer;
import org.springframework.util.FileCopyUtils;

public class ProtobufHttpMessageConverter
extends AbstractHttpMessageConverter<Message> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final MediaType PROTOBUF = new MediaType("application", "x-protobuf", DEFAULT_CHARSET);
    public static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    public static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final ConcurrentHashMap<Class<?>, Method> methodCache = new ConcurrentHashMap();
    private ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();

    public ProtobufHttpMessageConverter() {
        this((ExtensionRegistryInitializer)null);
    }

    public ProtobufHttpMessageConverter(ExtensionRegistryInitializer registryInitializer) {
        super(PROTOBUF, MediaType.TEXT_PLAIN, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON);
        if (this.extensionRegistry != null) {
            registryInitializer.initializeExtensionRegistry(this.extensionRegistry);
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    @Override
    protected Message readInternal(Class<? extends Message> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        contentType = contentType != null ? contentType : PROTOBUF;
        Charset charset = this.getCharset(inputMessage.getHeaders());
        InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
        try {
            Message.Builder builder = this.getMessageBuilder(clazz);
            if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                JsonFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
            } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
                TextFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
            } else if (MediaType.APPLICATION_XML.isCompatibleWith(contentType)) {
                XmlFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
            } else {
                builder.mergeFrom(inputMessage.getBody(), (ExtensionRegistryLite)this.extensionRegistry);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new HttpMessageNotReadableException("Could not read Protobuf message: " + e.getMessage(), e);
        }
    }

    private Charset getCharset(HttpHeaders headers) {
        if (headers == null || headers.getContentType() == null || headers.getContentType().getCharSet() == null) {
            return DEFAULT_CHARSET;
        }
        return headers.getContentType().getCharSet();
    }

    private Message.Builder getMessageBuilder(Class<? extends Message> clazz) throws Exception {
        Method method = methodCache.get(clazz);
        if (method == null) {
            method = clazz.getMethod("newBuilder", new Class[0]);
            methodCache.put(clazz, method);
        }
        return (Message.Builder)method.invoke(clazz, new Object[0]);
    }

    @Override
    protected boolean canWrite(MediaType mediaType) {
        return super.canWrite(mediaType) || MediaType.TEXT_HTML.isCompatibleWith(mediaType);
    }

    @Override
    protected void writeInternal(Message message, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        Charset charset = this.getCharset(contentType);
        OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), charset);
        if (MediaType.TEXT_HTML.isCompatibleWith(contentType)) {
            HtmlFormat.print((Message)message, (Appendable)writer);
        } else if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
            JsonFormat.print((Message)message, (Appendable)writer);
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            TextFormat.print((MessageOrBuilder)message, (Appendable)writer);
        } else if (MediaType.APPLICATION_XML.isCompatibleWith(contentType)) {
            XmlFormat.print((Message)message, (Appendable)writer);
        } else if (PROTOBUF.isCompatibleWith(contentType)) {
            this.setProtoHeader(outputMessage, message);
            FileCopyUtils.copy((byte[])message.toByteArray(), (OutputStream)outputMessage.getBody());
        }
    }

    private Charset getCharset(MediaType contentType) {
        return contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
    }

    private void setProtoHeader(HttpOutputMessage response, Message message) {
        response.getHeaders().set(X_PROTOBUF_SCHEMA_HEADER, message.getDescriptorForType().getFile().getName());
        response.getHeaders().set(X_PROTOBUF_MESSAGE_HEADER, message.getDescriptorForType().getFullName());
    }

    @Override
    protected MediaType getDefaultContentType(Message message) {
        return PROTOBUF;
    }
}

