/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();
    private static final String PARAMETER_DELIMETER = "&";

    public static String htmlEscape(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeQueryStringParameters(String queryString) {
        if (!StringUtils.hasText((String)queryString)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(queryString.length() * 2);
        String[] parameters = StringUtils.tokenizeToStringArray((String)queryString, (String)PARAMETER_DELIMETER);
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = parameters[i];
                buffer.append(HtmlUtils.htmlEscape(parameter));
                if (i >= parameters.length - 1) continue;
                buffer.append(PARAMETER_DELIMETER);
            }
        }
        return buffer.toString();
    }

    public static String htmlEscapeHex(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        if (input == null) {
            return null;
        }
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }
}

