/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.File;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.WebUtils;

public abstract class WebApplicationObjectSupport
extends ApplicationObjectSupport {
    protected boolean isContextRequired() {
        return true;
    }

    protected final WebApplicationContext getWebApplicationContext() throws IllegalStateException {
        ApplicationContext ctx = this.getApplicationContext();
        if (!(ctx instanceof WebApplicationContext)) {
            throw new IllegalStateException("WebApplicationObjectSupport instance [" + (Object)((Object)this) + "] does not run in a WebApplicationContext but in: " + ctx);
        }
        return (WebApplicationContext)this.getApplicationContext();
    }

    protected final ServletContext getServletContext() throws IllegalStateException {
        return this.getWebApplicationContext().getServletContext();
    }

    protected final File getTempDir() throws IllegalStateException {
        return WebUtils.getTempDir(this.getServletContext());
    }
}

