/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import org.jspecify.annotations.Nullable;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResultAssert;

final class DefaultMvcTestResult
implements MvcTestResult {
    private final @Nullable MvcResult mvcResult;
    private final @Nullable Exception unresolvedException;
    private final @Nullable JsonConverterDelegate converterDelegate;

    DefaultMvcTestResult(@Nullable MvcResult mvcResult, @Nullable Exception unresolvedException, @Nullable JsonConverterDelegate converterDelegate) {
        this.mvcResult = mvcResult;
        this.unresolvedException = unresolvedException;
        this.converterDelegate = converterDelegate;
    }

    @Override
    public MvcResult getMvcResult() {
        if (this.mvcResult == null) {
            throw new IllegalStateException("Request failed with unresolved exception " + String.valueOf(this.unresolvedException));
        }
        return this.mvcResult;
    }

    @Override
    public @Nullable Exception getUnresolvedException() {
        return this.unresolvedException;
    }

    public @Nullable Exception getResolvedException() {
        return this.getMvcResult().getResolvedException();
    }

    public MvcTestResultAssert assertThat() {
        return new MvcTestResultAssert(this, this.converterDelegate);
    }
}

