/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.MethodInvoker;
import org.springframework.test.context.TestContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultTestContext
implements TestContext {
    private static final long serialVersionUID = -5827157174866681233L;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(4);
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration mergedConfig;
    private final Class<?> testClass;
    private volatile @Nullable Object testInstance;
    private volatile @Nullable Method testMethod;
    private volatile @Nullable Throwable testException;
    private volatile MethodInvoker methodInvoker = MethodInvoker.DEFAULT_INVOKER;

    public DefaultTestContext(DefaultTestContext testContext) {
        this(testContext.testClass, testContext.mergedConfig, testContext.cacheAwareContextLoaderDelegate);
        this.attributes.putAll(testContext.attributes);
    }

    public DefaultTestContext(Class<?> testClass, MergedContextConfiguration mergedConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        Assert.notNull(testClass, (String)"Test Class must not be null");
        Assert.notNull((Object)mergedConfig, (String)"MergedContextConfiguration must not be null");
        Assert.notNull((Object)cacheAwareContextLoaderDelegate, (String)"CacheAwareContextLoaderDelegate must not be null");
        this.testClass = testClass;
        this.mergedConfig = mergedConfig;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
    }

    @Override
    public boolean hasApplicationContext() {
        return this.cacheAwareContextLoaderDelegate.isContextLoaded(this.mergedConfig);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        ApplicationContext context = this.cacheAwareContextLoaderDelegate.loadContext(this.mergedConfig);
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)context;
            Assert.state((boolean)cac.isActive(), () -> "The ApplicationContext loaded for %s is not active. This may be due to one of the following reasons: 1) the context was closed programmatically by user code; 2) the context was closed during parallel test execution either according to @DirtiesContext semantics or due to automatic eviction from the ContextCache due to a maximum cache size policy.".formatted(this.mergedConfig));
        }
        this.cacheAwareContextLoaderDelegate.registerContextUsage(this.mergedConfig, this.testClass);
        return context;
    }

    @Override
    public void markApplicationContextUnused() {
        this.cacheAwareContextLoaderDelegate.unregisterContextUsage(this.mergedConfig, this.testClass);
    }

    @Override
    public void markApplicationContextDirty(@Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        this.cacheAwareContextLoaderDelegate.closeContext(this.mergedConfig, hierarchyMode);
    }

    @Override
    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public final Object getTestInstance() {
        Object testInstance = this.testInstance;
        Assert.state((testInstance != null ? 1 : 0) != 0, (String)"No test instance");
        return testInstance;
    }

    @Override
    public final Method getTestMethod() {
        Method testMethod = this.testMethod;
        Assert.state((testMethod != null ? 1 : 0) != 0, (String)"No test method");
        return testMethod;
    }

    @Override
    public final @Nullable Throwable getTestException() {
        return this.testException;
    }

    @Override
    public void updateState(@Nullable Object testInstance, @Nullable Method testMethod, @Nullable Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    @Override
    public final void setMethodInvoker(MethodInvoker methodInvoker) {
        Assert.notNull((Object)methodInvoker, (String)"MethodInvoker must not be null");
        this.methodInvoker = methodInvoker;
    }

    @Override
    public final MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
    }

    public @Nullable Object getAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.get(name);
    }

    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(computeFunction, (String)"Compute function must not be null");
        Object value = this.attributes.computeIfAbsent(name, computeFunction);
        Assert.state((value != null ? 1 : 0) != 0, () -> "Compute function must not return null for attribute named '%s'".formatted(name));
        return (T)value;
    }

    public @Nullable Object removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return this.attributes.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] attributeNames() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return StringUtils.toStringArray(this.attributes.keySet());
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this, (ToStringStyler)new DefaultToStringStyler((ValueStyler)new SimpleValueStyler())).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedConfig).append("attributes", this.attributes).toString();
    }
}

