/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private Flux<DataBuffer> body = Flux.empty();

    public MockClientHttpResponse(int status) {
        this(HttpStatusCode.valueOf((int)status));
    }

    public MockClientHttpResponse(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode must not be null");
        this.statusCode = status;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public HttpHeaders getHeaders() {
        if (!this.getCookies().isEmpty() && this.headers.get("Set-Cookie") == null) {
            this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.headers.add("Set-Cookie", cookie.toString()));
        }
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public void setBody(Publisher<DataBuffer> body2) {
        this.body = Flux.from(body2);
    }

    public void setBody(String body2) {
        this.setBody(body2, StandardCharsets.UTF_8);
    }

    public void setBody(String body2, Charset charset) {
        DataBuffer buffer = this.toDataBuffer(body2, charset);
        this.body = Flux.just((Object)buffer);
    }

    private DataBuffer toDataBuffer(String body2, Charset charset) {
        byte[] bytes = body2.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return DefaultDataBufferFactory.sharedInstance.wrap(byteBuffer);
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        return DataBufferUtils.join(this.getBody()).map(buffer -> {
            String s = buffer.toString(this.getCharset());
            DataBufferUtils.release((DataBuffer)buffer);
            return s;
        }).defaultIfEmpty((Object)"");
    }

    private Charset getCharset() {
        Charset charset = null;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    public String toString() {
        HttpStatusCode httpStatusCode = this.statusCode;
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            return status.name() + "(" + String.valueOf(this.statusCode) + ")" + String.valueOf(this.headers);
        }
        return "Status (" + String.valueOf(this.statusCode) + ")" + String.valueOf(this.headers);
    }
}

