/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import jakarta.servlet.Filter;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.client.MockMvcHttpConnector;
import org.springframework.test.web.servlet.client.MockMvcWebTestClient;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.test.web.servlet.setup.RouterFunctionMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

abstract class MockMvcWebTestClientSpecs {
    MockMvcWebTestClientSpecs() {
    }

    static class StandaloneMockMvcSpec
    extends AbstractMockMvcServerSpec<MockMvcWebTestClient.ControllerSpec>
    implements MockMvcWebTestClient.ControllerSpec {
        private final StandaloneMockMvcBuilder mockMvcBuilder;

        StandaloneMockMvcSpec(Object ... controllers) {
            this.mockMvcBuilder = MockMvcBuilders.standaloneSetup(controllers);
        }

        @Override
        public StandaloneMockMvcSpec controllerAdvice(Object ... controllerAdvice) {
            this.mockMvcBuilder.setControllerAdvice(controllerAdvice);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec messageConverters(HttpMessageConverter<?> ... messageConverters) {
            this.mockMvcBuilder.setMessageConverters(messageConverters);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec validator(Validator validator) {
            this.mockMvcBuilder.setValidator(validator);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec conversionService(FormattingConversionService conversionService) {
            this.mockMvcBuilder.setConversionService(conversionService);
            return this;
        }

        @Override
        public MockMvcWebTestClient.ControllerSpec apiVersionStrategy(ApiVersionStrategy versionStrategy) {
            this.mockMvcBuilder.setApiVersionStrategy(versionStrategy);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec interceptors(HandlerInterceptor ... interceptors) {
            this.mappedInterceptors(null, interceptors);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec mappedInterceptors(String @Nullable [] pathPatterns, HandlerInterceptor ... interceptors) {
            this.mockMvcBuilder.addMappedInterceptors(pathPatterns, interceptors);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec contentNegotiationManager(ContentNegotiationManager manager) {
            this.mockMvcBuilder.setContentNegotiationManager(manager);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec asyncRequestTimeout(long timeout) {
            this.mockMvcBuilder.setAsyncRequestTimeout(timeout);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec customArgumentResolvers(HandlerMethodArgumentResolver ... argumentResolvers) {
            this.mockMvcBuilder.setCustomArgumentResolvers(argumentResolvers);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec customReturnValueHandlers(HandlerMethodReturnValueHandler ... handlers) {
            this.mockMvcBuilder.setCustomReturnValueHandlers(handlers);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec handlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
            this.mockMvcBuilder.setHandlerExceptionResolvers(exceptionResolvers);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec viewResolvers(ViewResolver ... resolvers) {
            this.mockMvcBuilder.setViewResolvers(resolvers);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec singleView(View view) {
            this.mockMvcBuilder.setSingleView(view);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec localeResolver(LocaleResolver localeResolver) {
            this.mockMvcBuilder.setLocaleResolver(localeResolver);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec flashMapManager(FlashMapManager flashMapManager) {
            this.mockMvcBuilder.setFlashMapManager(flashMapManager);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec patternParser(PathPatternParser parser) {
            this.mockMvcBuilder.setPatternParser(parser);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec placeholderValue(String name, String value) {
            this.mockMvcBuilder.addPlaceholderValue(name, value);
            return this;
        }

        @Override
        public StandaloneMockMvcSpec customHandlerMapping(Supplier<RequestMappingHandlerMapping> factory) {
            this.mockMvcBuilder.setCustomHandlerMapping(factory);
            return this;
        }

        @Override
        public ConfigurableMockMvcBuilder<?> getMockMvcBuilder() {
            return this.mockMvcBuilder;
        }
    }

    static class RouterFunctionMockMvcSpec
    extends AbstractMockMvcServerSpec<MockMvcWebTestClient.RouterFunctionSpec>
    implements MockMvcWebTestClient.RouterFunctionSpec {
        private final RouterFunctionMockMvcBuilder mockMvcBuilder;

        RouterFunctionMockMvcSpec(RouterFunction<?> ... routerFunctions) {
            this.mockMvcBuilder = MockMvcBuilders.routerFunctions(routerFunctions);
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec messageConverters(HttpMessageConverter<?> ... messageConverters) {
            this.mockMvcBuilder.setMessageConverters(messageConverters);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec interceptors(HandlerInterceptor ... interceptors) {
            this.mappedInterceptors(null, interceptors);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec mappedInterceptors(String @Nullable [] pathPatterns, HandlerInterceptor ... interceptors) {
            this.mockMvcBuilder.addMappedInterceptors(pathPatterns, interceptors);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec asyncRequestTimeout(long timeout) {
            this.mockMvcBuilder.setAsyncRequestTimeout(timeout);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec handlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
            this.mockMvcBuilder.setHandlerExceptionResolvers(exceptionResolvers);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec viewResolvers(ViewResolver ... resolvers) {
            this.mockMvcBuilder.setViewResolvers(resolvers);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec singleView(View view) {
            this.mockMvcBuilder.setSingleView(view);
            return this;
        }

        @Override
        public MockMvcWebTestClient.RouterFunctionSpec patternParser(PathPatternParser parser) {
            this.mockMvcBuilder.setPatternParser(parser);
            return this;
        }

        @Override
        protected ConfigurableMockMvcBuilder<?> getMockMvcBuilder() {
            return this.mockMvcBuilder;
        }
    }

    static class ApplicationContextMockMvcSpec
    extends AbstractMockMvcServerSpec<ApplicationContextMockMvcSpec> {
        private final DefaultMockMvcBuilder mockMvcBuilder;

        public ApplicationContextMockMvcSpec(WebApplicationContext context) {
            this.mockMvcBuilder = MockMvcBuilders.webAppContextSetup(context);
        }

        @Override
        protected ConfigurableMockMvcBuilder<?> getMockMvcBuilder() {
            return this.mockMvcBuilder;
        }
    }

    static abstract class AbstractMockMvcServerSpec<B extends MockMvcWebTestClient.MockMvcServerSpec<B>>
    implements MockMvcWebTestClient.MockMvcServerSpec<B> {
        AbstractMockMvcServerSpec() {
        }

        @Override
        public <T extends B> T filters(Filter ... filters) {
            this.getMockMvcBuilder().addFilters(filters);
            return this.self();
        }

        @Override
        public final <T extends B> T filter(Filter filter, String ... urlPatterns) {
            this.getMockMvcBuilder().addFilter(filter, urlPatterns);
            return this.self();
        }

        @Override
        public <T extends B> T defaultRequest(RequestBuilder requestBuilder) {
            this.getMockMvcBuilder().defaultRequest(requestBuilder);
            return this.self();
        }

        @Override
        public <T extends B> T alwaysExpect(ResultMatcher resultMatcher) {
            this.getMockMvcBuilder().alwaysExpect(resultMatcher);
            return this.self();
        }

        @Override
        public <T extends B> T dispatchOptions(boolean dispatchOptions) {
            this.getMockMvcBuilder().dispatchOptions(dispatchOptions);
            return this.self();
        }

        @Override
        public <T extends B> T dispatcherServletCustomizer(DispatcherServletCustomizer customizer) {
            this.getMockMvcBuilder().addDispatcherServletCustomizer(customizer);
            return this.self();
        }

        @Override
        public <T extends B> T apply(MockMvcConfigurer configurer) {
            this.getMockMvcBuilder().apply(configurer);
            return this.self();
        }

        private <T extends B> T self() {
            return (T)this;
        }

        protected abstract ConfigurableMockMvcBuilder<?> getMockMvcBuilder();

        @Override
        public WebTestClient.Builder configureClient() {
            MockMvc mockMvc = this.getMockMvcBuilder().build();
            MockMvcHttpConnector connector = new MockMvcHttpConnector(mockMvc);
            return WebTestClient.bindToServer(connector);
        }

        @Override
        public WebTestClient build() {
            return this.configureClient().build();
        }
    }
}

