/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ClientHttpResponseDecorator;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.JsonEncoderDecoder;
import org.springframework.test.web.reactive.server.MockServerClientHttpResponse;
import org.springframework.util.Assert;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

class WiretapConnector
implements ClientHttpConnector {
    private final ClientHttpConnector delegate;
    private final @Nullable JsonConverterDelegate converterDelegate;
    private final Map<String, ClientExchangeInfo> exchanges = new ConcurrentHashMap<String, ClientExchangeInfo>();

    WiretapConnector(ClientHttpConnector delegate, @Nullable JsonEncoderDecoder encoderDecoder) {
        this.delegate = delegate;
        this.converterDelegate = encoderDecoder != null ? encoderDecoder.createJsonConverterDelegate() : null;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference requestRef = new AtomicReference();
        return this.delegate.connect(method, uri, request -> {
            WiretapClientHttpRequest wrapped = new WiretapClientHttpRequest((ClientHttpRequest)request);
            requestRef.set(wrapped);
            return (Mono)requestCallback.apply((ClientHttpRequest)wrapped);
        }).map(response -> {
            WiretapClientHttpRequest wrappedRequest = (WiretapClientHttpRequest)((Object)((Object)requestRef.get()));
            String header = "WebTestClient-Request-Id";
            String requestId = wrappedRequest.getHeaders().getFirst(header);
            Assert.state((requestId != null ? 1 : 0) != 0, () -> "No \"" + header + "\" header");
            WiretapClientHttpResponse wrappedResponse = new WiretapClientHttpResponse((ClientHttpResponse)response);
            this.exchanges.put(requestId, new ClientExchangeInfo(wrappedRequest, wrappedResponse));
            return wrappedResponse;
        });
    }

    ExchangeResult getExchangeResult(String requestId, @Nullable String uriTemplate, Duration timeout) {
        ClientExchangeInfo clientInfo = this.exchanges.remove(requestId);
        Assert.state((clientInfo != null ? 1 : 0) != 0, () -> "No match for %s=%s".formatted("WebTestClient-Request-Id", requestId));
        return new ExchangeResult((ClientHttpRequest)clientInfo.getRequest(), (ClientHttpResponse)clientInfo.getResponse(), clientInfo.getRequest().getRecorder().getContent(), clientInfo.getResponse().getRecorder().getContent(), timeout, uriTemplate, clientInfo.getResponse().getMockServerResult(), this.converterDelegate);
    }

    private static class ClientExchangeInfo {
        private final WiretapClientHttpRequest request;
        private final WiretapClientHttpResponse response;

        public ClientExchangeInfo(WiretapClientHttpRequest request, WiretapClientHttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public WiretapClientHttpRequest getRequest() {
            return this.request;
        }

        public WiretapClientHttpResponse getResponse() {
            return this.response;
        }
    }

    private static class WiretapClientHttpRequest
    extends ClientHttpRequestDecorator {
        private @Nullable WiretapRecorder recorder;

        public WiretapClientHttpRequest(ClientHttpRequest delegate) {
            super(delegate);
        }

        public WiretapRecorder getRecorder() {
            Assert.notNull((Object)this.recorder, (String)"No WiretapRecorder: was the client request written?");
            return this.recorder;
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> publisher) {
            this.recorder = new WiretapRecorder(publisher, null);
            return super.writeWith(this.recorder.getPublisherToUse());
        }

        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
            this.recorder = new WiretapRecorder(null, publisher);
            return super.writeAndFlushWith(this.recorder.getNestedPublisherToUse());
        }

        public Mono<Void> setComplete() {
            this.recorder = new WiretapRecorder(null, null);
            return super.setComplete();
        }
    }

    private static class WiretapClientHttpResponse
    extends ClientHttpResponseDecorator {
        private final WiretapRecorder recorder = new WiretapRecorder((Publisher<? extends DataBuffer>)super.getBody(), null);

        public WiretapClientHttpResponse(ClientHttpResponse delegate) {
            super(delegate);
        }

        public WiretapRecorder getRecorder() {
            return this.recorder;
        }

        public Flux<DataBuffer> getBody() {
            return Flux.from(this.recorder.getPublisherToUse());
        }

        public @Nullable Object getMockServerResult() {
            Object object;
            ClientHttpResponse clientHttpResponse = this.getDelegate();
            if (clientHttpResponse instanceof MockServerClientHttpResponse) {
                MockServerClientHttpResponse mockResponse = (MockServerClientHttpResponse)clientHttpResponse;
                object = mockResponse.getServerResult();
            } else {
                object = null;
            }
            return object;
        }
    }

    static final class WiretapRecorder {
        private final @Nullable Flux<? extends DataBuffer> publisher;
        private final @Nullable Flux<? extends Publisher<? extends DataBuffer>> publisherNested;
        private final DataBuffer buffer = DefaultDataBufferFactory.sharedInstance.allocateBuffer(256);
        private final Sinks.One<byte[]> content = Sinks.unsafe().one();
        private boolean hasContentConsumer;

        public WiretapRecorder(@Nullable Publisher<? extends DataBuffer> publisher, @Nullable Publisher<? extends Publisher<? extends DataBuffer>> publisherNested) {
            Flux flux;
            if (publisher != null && publisherNested != null) {
                throw new IllegalArgumentException("At most one publisher expected");
            }
            if (publisher != null) {
                Flux flux2 = Flux.from(publisher).doOnSubscribe(s -> {
                    this.hasContentConsumer = true;
                });
                DataBuffer dataBuffer = this.buffer;
                Objects.requireNonNull(dataBuffer);
                DataBuffer dataBuffer2 = dataBuffer;
                flux = flux2.doOnNext(xva$0 -> dataBuffer2.write(new DataBuffer[]{xva$0})).doOnError(this::handleOnError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete);
            } else {
                flux = null;
            }
            this.publisher = flux;
            Flux<? extends Publisher<? extends DataBuffer>> flux3 = this.publisherNested = publisherNested != null ? Flux.from(publisherNested).doOnSubscribe(s -> {
                this.hasContentConsumer = true;
            }).map(p -> {
                Flux flux = Flux.from((Publisher)p);
                DataBuffer dataBuffer = this.buffer;
                Objects.requireNonNull(dataBuffer);
                DataBuffer rec$ = dataBuffer;
                return flux.doOnNext(xva$0 -> rec$.write(new DataBuffer[]{xva$0})).doOnError(this::handleOnError);
            }).doOnError(this::handleOnError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete) : null;
            if (publisher == null && publisherNested == null) {
                this.content.tryEmitEmpty();
            }
        }

        public Publisher<? extends DataBuffer> getPublisherToUse() {
            Assert.notNull(this.publisher, (String)"Publisher not in use.");
            return this.publisher;
        }

        public Publisher<? extends Publisher<? extends DataBuffer>> getNestedPublisherToUse() {
            Assert.notNull(this.publisherNested, (String)"Nested publisher not in use.");
            return this.publisherNested;
        }

        public Mono<byte[]> getContent() {
            return Mono.defer(() -> {
                if (this.content.scan(Scannable.Attr.TERMINATED) == Boolean.TRUE) {
                    return this.content.asMono();
                }
                if (!this.hasContentConsumer) {
                    (this.publisher != null ? this.publisher : this.publisherNested).onErrorMap(ex -> new IllegalStateException("Content has not been consumed, and an error was raised while attempting to produce it.", (Throwable)ex)).subscribe();
                }
                return this.content.asMono();
            });
        }

        private void handleOnError(Throwable ex) {
            this.content.tryEmitError(ex);
        }

        private void handleOnComplete() {
            byte[] bytes = new byte[this.buffer.readableByteCount()];
            this.buffer.read(bytes);
            this.content.tryEmitValue((Object)bytes);
        }
    }
}

