/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.bean.override.BeanOverrideContextCustomizer;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.util.Assert;

class BeanOverrideContextCustomizerFactory
implements ContextCustomizerFactory {
    BeanOverrideContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public BeanOverrideContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        LinkedHashSet<BeanOverrideHandler> handlers = new LinkedHashSet<BeanOverrideHandler>();
        this.findBeanOverrideHandlers(testClass, handlers);
        if (handlers.isEmpty()) {
            return null;
        }
        return new BeanOverrideContextCustomizer(handlers);
    }

    private void findBeanOverrideHandlers(Class<?> testClass, Set<BeanOverrideHandler> handlers) {
        BeanOverrideHandler.findAllHandlers(testClass).forEach(handler -> Assert.state((boolean)handlers.add((BeanOverrideHandler)handler), () -> "Duplicate BeanOverrideHandler discovered in test class %s: %s".formatted(testClass.getName(), handler)));
    }
}

