/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit.webdriver;

import org.htmlunit.BrowserVersion;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnectionBuilderSupport;
import org.springframework.test.web.servlet.htmlunit.webdriver.WebConnectionHtmlUnitDriver;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcHtmlUnitDriverBuilder
extends MockMvcWebConnectionBuilderSupport<MockMvcHtmlUnitDriverBuilder> {
    @Nullable
    private HtmlUnitDriver driver;
    private boolean javascriptEnabled = true;

    protected MockMvcHtmlUnitDriverBuilder(MockMvc mockMvc) {
        super(mockMvc);
    }

    protected MockMvcHtmlUnitDriverBuilder(WebApplicationContext context) {
        super(context);
    }

    protected MockMvcHtmlUnitDriverBuilder(WebApplicationContext context, MockMvcConfigurer configurer) {
        super(context, configurer);
    }

    public static MockMvcHtmlUnitDriverBuilder mockMvcSetup(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        return new MockMvcHtmlUnitDriverBuilder(mockMvc);
    }

    public static MockMvcHtmlUnitDriverBuilder webAppContextSetup(WebApplicationContext context) {
        Assert.notNull((Object)context, (String)"WebApplicationContext must not be null");
        return new MockMvcHtmlUnitDriverBuilder(context);
    }

    public static MockMvcHtmlUnitDriverBuilder webAppContextSetup(WebApplicationContext context, MockMvcConfigurer configurer) {
        Assert.notNull((Object)context, (String)"WebApplicationContext must not be null");
        Assert.notNull((Object)configurer, (String)"MockMvcConfigurer must not be null");
        return new MockMvcHtmlUnitDriverBuilder(context, configurer);
    }

    public MockMvcHtmlUnitDriverBuilder javascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
        return this;
    }

    public MockMvcHtmlUnitDriverBuilder withDelegate(WebConnectionHtmlUnitDriver driver) {
        Assert.notNull((Object)((Object)driver), (String)"HtmlUnitDriver must not be null");
        driver.setJavascriptEnabled(this.javascriptEnabled);
        driver.setWebConnection(this.createConnection(driver.getWebClient()));
        this.driver = driver;
        return this;
    }

    public HtmlUnitDriver build() {
        return this.driver != null ? this.driver : this.withDelegate(new WebConnectionHtmlUnitDriver(BrowserVersion.CHROME)).build();
    }
}

