/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonPathExpectationsHelper {
    private final String expression;
    private final JsonPath jsonPath;

    public JsonPathExpectationsHelper(String expression, Object ... args) {
        Assert.hasText((String)expression, (String)"expression must not be null or empty");
        this.expression = String.format(expression, args);
        this.jsonPath = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
    }

    public <T> void assertValue(String content, Matcher<? super T> matcher) {
        Object value = this.evaluateJsonPath(content);
        MatcherAssert.assertThat((String)("JSON path \"" + this.expression + "\""), (Object)value, matcher);
    }

    public <T> void assertValue(String content, Matcher<? super T> matcher, Class<T> targetType) {
        Object value = this.evaluateJsonPath(content, targetType);
        MatcherAssert.assertThat((String)("JSON path \"" + this.expression + "\""), (Object)value, matcher);
    }

    /*
     * Unable to fully structure code
     */
    public void assertValue(String content, @Nullable Object expectedValue) {
        actualValue = this.evaluateJsonPath(content);
        if (!(actualValue instanceof List)) ** GOTO lbl-1000
        actualValueList = (List)actualValue;
        if (!(expectedValue instanceof List)) {
            if (actualValueList.isEmpty()) {
                AssertionErrors.fail("No matching value at JSON path \"" + this.expression + "\"");
            }
            if (actualValueList.size() != 1) {
                AssertionErrors.fail("Got a list of values " + actualValue + " instead of the expected single value " + expectedValue);
            }
            actualValue = actualValueList.get(0);
        } else if (actualValue != null && expectedValue != null && !actualValue.getClass().equals(expectedValue.getClass())) {
            try {
                actualValue = this.evaluateJsonPath(content, expectedValue.getClass());
            }
            catch (AssertionError error) {
                message = String.format("At JSON path \"%s\", value <%s> of type <%s> cannot be converted to type <%s>", new Object[]{this.expression, actualValue, ClassUtils.getDescriptiveType((Object)actualValue), ClassUtils.getDescriptiveType((Object)expectedValue)});
                throw new AssertionError(message, error.getCause());
            }
        }
        AssertionErrors.assertEquals("JSON path \"" + this.expression + "\"", expectedValue, actualValue);
    }

    public void assertValueIsString(String content) {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a string", value), (Object)value, (Matcher)CoreMatchers.instanceOf(String.class));
    }

    public void assertValueIsBoolean(String content) {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a boolean", value), (Object)value, (Matcher)CoreMatchers.instanceOf(Boolean.class));
    }

    public void assertValueIsNumber(String content) {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a number", value), (Object)value, (Matcher)CoreMatchers.instanceOf(Number.class));
    }

    public void assertValueIsArray(String content) {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("an array", value), (Object)value, (Matcher)CoreMatchers.instanceOf(List.class));
    }

    public void assertValueIsMap(String content) {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a map", value), (Object)value, (Matcher)CoreMatchers.instanceOf(Map.class));
    }

    public void exists(String content) {
        this.assertExistsAndReturn(content);
    }

    public void doesNotExist(String content) {
        Object value;
        try {
            value = this.evaluateJsonPath(content);
        }
        catch (AssertionError ex) {
            return;
        }
        String reason = this.failureReason("no value", value);
        if (this.pathIsIndefinite() && value instanceof List) {
            List list = (List)value;
            AssertionErrors.assertTrue(reason, list.isEmpty());
        } else {
            AssertionErrors.assertTrue(reason, value == null);
        }
    }

    public void assertValueIsEmpty(String content) {
        Object value = this.evaluateJsonPath(content);
        AssertionErrors.assertTrue(this.failureReason("an empty value", value), ObjectUtils.isEmpty((Object)value));
    }

    public void assertValueIsNotEmpty(String content) {
        Object value = this.evaluateJsonPath(content);
        AssertionErrors.assertTrue(this.failureReason("a non-empty value", value), !ObjectUtils.isEmpty((Object)value));
    }

    public void hasJsonPath(String content) {
        Object value = this.evaluateJsonPath(content);
        if (this.pathIsIndefinite() && value instanceof List) {
            List list = (List)value;
            String message = "No values for JSON path \"" + this.expression + "\"";
            AssertionErrors.assertTrue(message, !list.isEmpty());
        }
    }

    public void doesNotHaveJsonPath(String content) {
        Object value;
        try {
            value = this.evaluateJsonPath(content);
        }
        catch (AssertionError ex) {
            return;
        }
        if (this.pathIsIndefinite() && value instanceof List) {
            List list = (List)value;
            AssertionErrors.assertTrue(this.failureReason("no values", value), list.isEmpty());
        } else {
            AssertionErrors.fail(this.failureReason("no value", value));
        }
    }

    private String failureReason(String expectedDescription, @Nullable Object value) {
        return String.format("Expected %s at JSON path \"%s\" but found: %s", expectedDescription, this.expression, ObjectUtils.nullSafeToString((Object)StringUtils.quoteIfString((Object)value)));
    }

    @Nullable
    public Object evaluateJsonPath(String content) {
        try {
            return this.jsonPath.read(content);
        }
        catch (Throwable ex) {
            throw new AssertionError("No value at JSON path \"" + this.expression + "\"", ex);
        }
    }

    public Object evaluateJsonPath(String content, Class<?> targetType) {
        try {
            return JsonPath.parse((String)content).read(this.expression, targetType, new Predicate[0]);
        }
        catch (Throwable ex) {
            String message = "No value at JSON path \"" + this.expression + "\"";
            throw new AssertionError(message, ex);
        }
    }

    @Nullable
    private Object assertExistsAndReturn(String content) {
        Object value = this.evaluateJsonPath(content);
        String reason = "No value at JSON path \"" + this.expression + "\"";
        AssertionErrors.assertTrue(reason, value != null);
        if (this.pathIsIndefinite() && value instanceof List) {
            List list = (List)value;
            AssertionErrors.assertTrue(reason, !list.isEmpty());
        }
        return value;
    }

    private boolean pathIsIndefinite() {
        return !this.jsonPath.isDefinite();
    }
}

