/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapUtils;
import org.springframework.test.context.MethodInvoker;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TestContextManager {
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    private static final Set<Class<? extends Throwable>> skippedExceptionTypes = new LinkedHashSet<Class<? extends Throwable>>(4);
    private final TestContext testContext;
    private final ThreadLocal<TestContext> testContextHolder;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>(8);

    public TestContextManager(Class<?> testClass) {
        this(BootstrapUtils.resolveTestContextBootstrapper(testClass));
    }

    public TestContextManager(TestContextBootstrapper testContextBootstrapper) {
        this.testContext = testContextBootstrapper.buildTestContext();
        this.testContextHolder = ThreadLocal.withInitial(() -> TestContextManager.copyTestContext(this.testContext));
        this.registerTestExecutionListeners(testContextBootstrapper.getTestExecutionListeners());
    }

    public final TestContext getTestContext() {
        return this.testContextHolder.get();
    }

    public void registerTestExecutionListeners(List<TestExecutionListener> testExecutionListeners) {
        this.registerTestExecutionListeners(testExecutionListeners.toArray(new TestExecutionListener[0]));
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener: " + TestContextManager.typeName(listener)));
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestClass() throws Exception {
        try {
            Class<?> testClass = this.getTestContext().getTestClass();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("beforeTestClass(): class [" + TestContextManager.typeName(testClass) + "]"));
            }
            this.getTestContext().updateState(null, null, null);
            for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
                try {
                    testExecutionListener.beforeTestClass(this.getTestContext());
                }
                catch (Throwable ex) {
                    this.logException(ex, "beforeTestClass", testExecutionListener, testClass);
                    ReflectionUtils.rethrowException((Throwable)ex);
                }
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareTestInstance(Object testInstance) throws Exception {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
            }
            this.getTestContext().updateState(testInstance, null, null);
            for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
                try {
                    testExecutionListener.prepareTestInstance(this.getTestContext());
                }
                catch (Throwable ex) {
                    if (TestContextManager.isSkippedException(ex)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"Caught exception while allowing TestExecutionListener [%s] to prepare test instance [%s]".formatted(TestContextManager.typeName(testExecutionListener), testInstance), ex);
                        }
                    } else if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Caught exception while allowing TestExecutionListener [%s] to prepare test instance [%s]".formatted(TestContextManager.typeName(testExecutionListener), testInstance), ex);
                    }
                    ReflectionUtils.rethrowException((Throwable)ex);
                }
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        try {
            String callbackName = "beforeTestMethod";
            this.prepareForBeforeCallback(callbackName, testInstance, testMethod);
            for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
                try {
                    testExecutionListener.beforeTestMethod(this.getTestContext());
                }
                catch (Throwable ex) {
                    this.handleBeforeException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                }
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(Object testInstance, Method testMethod) throws Exception {
        try {
            String callbackName = "beforeTestExecution";
            this.prepareForBeforeCallback(callbackName, testInstance, testMethod);
            for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
                try {
                    testExecutionListener.beforeTestExecution(this.getTestContext());
                }
                catch (Throwable ex) {
                    this.handleBeforeException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                }
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestExecution(Object testInstance, Method testMethod, @Nullable Throwable exception) throws Exception {
        try {
            String callbackName = "afterTestExecution";
            this.prepareForAfterCallback(callbackName, testInstance, testMethod, exception);
            Throwable afterTestExecutionException = null;
            for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
                try {
                    testExecutionListener.afterTestExecution(this.getTestContext());
                }
                catch (Throwable ex) {
                    this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                    if (afterTestExecutionException == null) {
                        afterTestExecutionException = ex;
                        continue;
                    }
                    afterTestExecutionException.addSuppressed(ex);
                }
            }
            if (afterTestExecutionException != null) {
                ReflectionUtils.rethrowException(afterTestExecutionException);
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(Object testInstance, Method testMethod, @Nullable Throwable exception) throws Exception {
        try {
            String callbackName = "afterTestMethod";
            this.prepareForAfterCallback(callbackName, testInstance, testMethod, exception);
            Throwable afterTestMethodException = null;
            for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
                try {
                    testExecutionListener.afterTestMethod(this.getTestContext());
                }
                catch (Throwable ex) {
                    this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                    if (afterTestMethodException == null) {
                        afterTestMethodException = ex;
                        continue;
                    }
                    afterTestMethodException.addSuppressed(ex);
                }
            }
            if (afterTestMethodException != null) {
                ReflectionUtils.rethrowException(afterTestMethodException);
            }
        }
        finally {
            this.resetMethodInvoker();
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestClass(): class [" + TestContextManager.typeName(testClass) + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        Throwable afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Throwable ex) {
                this.logException(ex, "afterTestClass", testExecutionListener, testClass);
                if (afterTestClassException == null) {
                    afterTestClassException = ex;
                    continue;
                }
                afterTestClassException.addSuppressed(ex);
            }
        }
        this.testContextHolder.remove();
        if (afterTestClassException != null) {
            ReflectionUtils.rethrowException(afterTestClassException);
        }
    }

    private void resetMethodInvoker() {
        this.getTestContext().setMethodInvoker(MethodInvoker.DEFAULT_INVOKER);
    }

    private void prepareForBeforeCallback(String callbackName, Object testInstance, Method testMethod) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"%s(): instance [%s], method [%s]".formatted(callbackName, testInstance, testMethod));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
    }

    private void prepareForAfterCallback(String callbackName, Object testInstance, Method testMethod, @Nullable Throwable exception) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"%s(): instance [%s], method [%s], exception [%s]".formatted(callbackName, testInstance, testMethod, exception));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
    }

    private void handleBeforeException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Object testInstance, Method testMethod) throws Exception {
        this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
        ReflectionUtils.rethrowException((Throwable)ex);
    }

    private void logException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Class<?> testClass) {
        if (TestContextManager.isSkippedException(ex)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test class [%s]".formatted(callbackName, TestContextManager.typeName(testExecutionListener), TestContextManager.typeName(testClass)), ex);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test class [%s]".formatted(callbackName, TestContextManager.typeName(testExecutionListener), TestContextManager.typeName(testClass)), ex);
        }
    }

    private void logException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Object testInstance, Method testMethod) {
        if (TestContextManager.isSkippedException(ex)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test method [%s] and test instance [%s]".formatted(callbackName, TestContextManager.typeName(testExecutionListener), testMethod, testInstance), ex);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test method [%s] and test instance [%s]".formatted(callbackName, TestContextManager.typeName(testExecutionListener), testMethod, testInstance), ex);
        }
    }

    private static TestContext copyTestContext(TestContext testContext) {
        block3: {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(testContext.getClass(), (Class[])new Class[]{testContext.getClass()});
            if (constructor != null) {
                try {
                    ReflectionUtils.makeAccessible((Constructor)constructor);
                    return (TestContext)constructor.newInstance(testContext);
                }
                catch (Exception ex) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)"Failed to invoke copy constructor for [%s]; concurrent test execution is therefore likely not supported.".formatted(testContext), (Throwable)ex);
                }
            }
        }
        return testContext;
    }

    private static String typeName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Class) {
            Class type = (Class)obj;
            return type.getName();
        }
        return obj.getClass().getName();
    }

    private static void registerSkippedExceptionType(String name) {
        try {
            Class exceptionType = ClassUtils.forName((String)name, (ClassLoader)TestContextManager.class.getClassLoader());
            skippedExceptionTypes.add(exceptionType);
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
    }

    private static boolean isSkippedException(Throwable ex) {
        for (Class<? extends Throwable> skippedExceptionType : skippedExceptionTypes) {
            if (!skippedExceptionType.isInstance(ex)) continue;
            return true;
        }
        return false;
    }

    static {
        TestContextManager.registerSkippedExceptionType("org.opentest4j.TestAbortedException");
        TestContextManager.registerSkippedExceptionType("org.junit.AssumptionViolatedException");
        TestContextManager.registerSkippedExceptionType("org.testng.SkipException");
    }
}

