/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.observation;

import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.contextpropagation.ObservationThreadLocalAccessor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.platform.launcher.TestExecutionListener;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class MicrometerObservationRegistryTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger;
    private static final String OBSERVATION_THREAD_LOCAL_ACCESSOR_CLASS_NAME = "io.micrometer.observation.contextpropagation.ObservationThreadLocalAccessor";
    private static final String PREVIOUS_OBSERVATION_REGISTRY;

    MicrometerObservationRegistryTestExecutionListener() {
    }

    @Override
    public final int getOrder() {
        return 2500;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        testContext.getApplicationContext().getBeanProvider(ObservationRegistry.class).ifAvailable(registry -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering ObservationRegistry from ApplicationContext in ObservationThreadLocalAccessor for test class " + testContext.getTestClass().getName()));
            }
            ObservationThreadLocalAccessor accessor = ObservationThreadLocalAccessor.getInstance();
            testContext.setAttribute(PREVIOUS_OBSERVATION_REGISTRY, accessor.getObservationRegistry());
            accessor.setObservationRegistry(registry);
        });
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        ObservationRegistry previousObservationRegistry = (ObservationRegistry)testContext.removeAttribute(PREVIOUS_OBSERVATION_REGISTRY);
        if (previousObservationRegistry != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restoring ObservationRegistry in ObservationThreadLocalAccessor for test class " + testContext.getTestClass().getName()));
            }
            ObservationThreadLocalAccessor.getInstance().setObservationRegistry(previousObservationRegistry);
        }
    }

    static {
        Class<?> clazz;
        logger = LogFactory.getLog(MicrometerObservationRegistryTestExecutionListener.class);
        PREVIOUS_OBSERVATION_REGISTRY = Conventions.getQualifiedAttributeName(MicrometerObservationRegistryTestExecutionListener.class, (String)"previousObservationRegistry");
        String errorMessage = "MicrometerObservationRegistryTestExecutionListener requires micrometer-observation 1.10.8 or higher";
        try {
            clazz = Class.forName(OBSERVATION_THREAD_LOCAL_ACCESSOR_CLASS_NAME, true, TestExecutionListener.class.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException(errorMessage, ex);
        }
        Method method = ReflectionUtils.findMethod(clazz, (String)"getObservationRegistry");
        Assert.state((method != null ? 1 : 0) != 0, (String)errorMessage);
    }
}

