/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Part;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.mock.web.MockPart;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    MockMultipartHttpServletRequestBuilder(String urlTemplate, Object ... uriVariables) {
        super(HttpMethod.POST, urlTemplate, uriVariables);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    MockMultipartHttpServletRequestBuilder(URI uri) {
        super(HttpMethod.POST, uri);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    public MockMultipartHttpServletRequestBuilder part(Part ... parts) {
        Assert.notEmpty((Object[])parts, (String)"'parts' must not be empty");
        for (Part part : parts) {
            this.parts.add((Object)part.getName(), (Object)part);
        }
        return this;
    }

    @Override
    public Object merge(@Nullable Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof MockHttpServletRequestBuilder) {
            super.merge(parent);
            if (parent instanceof MockMultipartHttpServletRequestBuilder) {
                MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
                this.files.addAll(parentBuilder.files);
                parentBuilder.parts.keySet().forEach(name -> {
                    List cfr_ignored_0 = (List)this.parts.putIfAbsent(name, parentBuilder.parts.get(name));
                });
            }
        } else {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        return this;
    }

    @Override
    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request2 = new MockMultipartHttpServletRequest(servletContext);
        this.files.forEach(file -> request2.addPart(this.toMockPart((MockMultipartFile)file)));
        this.parts.values().stream().flatMap(Collection::stream).forEach(request2::addPart);
        return request2;
    }

    private MockPart toMockPart(MockMultipartFile file) {
        byte[] bytes = null;
        if (!file.isEmpty()) {
            try {
                bytes = file.getBytes();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unexpected IOException", ex);
            }
        }
        MockPart part = new MockPart(file.getName(), file.getOriginalFilename(), bytes);
        if (file.getContentType() != null) {
            part.getHeaders().set("Content-Type", file.getContentType());
        }
        return part;
    }
}

