/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultActiveProfilesResolver
implements ActiveProfilesResolver {
    private static final Log logger = LogFactory.getLog(DefaultActiveProfilesResolver.class);

    @Override
    public String[] resolve(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        HashSet<String> activeProfiles = new HashSet<String>();
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
            }
        } else {
            boolean profilesDeclared;
            Class<?> declaringClass = descriptor.getDeclaringClass();
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
            }
            Object[] profiles = annAttrs.getStringArray("profiles");
            Object[] valueProfiles = annAttrs.getStringArray("value");
            boolean valueDeclared = !ObjectUtils.isEmpty((Object[])valueProfiles);
            boolean bl = profilesDeclared = !ObjectUtils.isEmpty((Object[])profiles);
            if (valueDeclared && profilesDeclared) {
                String msg = String.format("Class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueProfiles), ObjectUtils.nullSafeToString((Object[])profiles));
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            if (valueDeclared) {
                profiles = valueProfiles;
            }
            for (Object profile : profiles) {
                if (!StringUtils.hasText((String)profile)) continue;
                activeProfiles.add(((String)profile).trim());
            }
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

