/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.remoting.jaxrpc.JaxRpcServicePostProcessor;

public class LocalJaxRpcServiceFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ServiceFactory serviceFactory;
    private Class serviceFactoryClass;
    private URL wsdlDocumentUrl;
    private String namespaceUri;
    private String serviceName;
    private Class jaxRpcServiceInterface;
    private Properties jaxRpcServiceProperties;
    private JaxRpcServicePostProcessor[] servicePostProcessors;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceFactory;

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactoryClass(Class serviceFactoryClass) {
        if (serviceFactoryClass != null && !(class$javax$xml$rpc$ServiceFactory == null ? (class$javax$xml$rpc$ServiceFactory = LocalJaxRpcServiceFactory.class$("javax.xml.rpc.ServiceFactory")) : class$javax$xml$rpc$ServiceFactory).isAssignableFrom(serviceFactoryClass)) {
            throw new IllegalArgumentException("'serviceFactoryClass' must implement [javax.xml.rpc.ServiceFactory]");
        }
        this.serviceFactoryClass = serviceFactoryClass;
    }

    public Class getServiceFactoryClass() {
        return this.serviceFactoryClass;
    }

    public void setWsdlDocumentUrl(URL wsdlDocumentUrl) {
        this.wsdlDocumentUrl = wsdlDocumentUrl;
    }

    public URL getWsdlDocumentUrl() {
        return this.wsdlDocumentUrl;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setJaxRpcServiceInterface(Class jaxRpcServiceInterface) {
        this.jaxRpcServiceInterface = jaxRpcServiceInterface;
    }

    public Class getJaxRpcServiceInterface() {
        return this.jaxRpcServiceInterface;
    }

    public void setJaxRpcServiceProperties(Properties jaxRpcServiceProperties) {
        this.jaxRpcServiceProperties = jaxRpcServiceProperties;
    }

    public Properties getJaxRpcServiceProperties() {
        return this.jaxRpcServiceProperties;
    }

    public void setServicePostProcessors(JaxRpcServicePostProcessor[] servicePostProcessors) {
        this.servicePostProcessors = servicePostProcessors;
    }

    public JaxRpcServicePostProcessor[] getServicePostProcessors() {
        return this.servicePostProcessors;
    }

    public Service createJaxRpcService() throws ServiceException {
        ServiceFactory serviceFactory = this.getServiceFactory();
        if (serviceFactory == null) {
            serviceFactory = this.createServiceFactory();
        }
        Service service = this.createService(serviceFactory);
        this.postProcessJaxRpcService(service);
        return service;
    }

    protected QName getQName(String name) {
        return this.getNamespaceUri() != null ? new QName(this.getNamespaceUri(), name) : new QName(name);
    }

    protected ServiceFactory createServiceFactory() throws ServiceException {
        if (this.getServiceFactoryClass() != null) {
            return (ServiceFactory)BeanUtils.instantiateClass((Class)this.getServiceFactoryClass());
        }
        return ServiceFactory.newInstance();
    }

    protected Service createService(ServiceFactory serviceFactory) throws ServiceException {
        if (this.getServiceName() == null && this.getJaxRpcServiceInterface() == null) {
            throw new IllegalArgumentException("Either 'serviceName' or 'jaxRpcServiceInterface' is required");
        }
        if (this.getJaxRpcServiceInterface() != null) {
            if (this.getWsdlDocumentUrl() != null || this.getJaxRpcServiceProperties() != null) {
                return serviceFactory.loadService(this.getWsdlDocumentUrl(), this.getJaxRpcServiceInterface(), this.getJaxRpcServiceProperties());
            }
            return serviceFactory.loadService(this.getJaxRpcServiceInterface());
        }
        QName serviceQName = this.getQName(this.getServiceName());
        if (this.getJaxRpcServiceProperties() != null) {
            return serviceFactory.loadService(this.getWsdlDocumentUrl(), serviceQName, this.getJaxRpcServiceProperties());
        }
        if (this.getWsdlDocumentUrl() != null) {
            return serviceFactory.createService(this.getWsdlDocumentUrl(), serviceQName);
        }
        return serviceFactory.createService(serviceQName);
    }

    protected void postProcessJaxRpcService(Service service) {
        JaxRpcServicePostProcessor[] postProcessors = this.getServicePostProcessors();
        if (postProcessors != null) {
            for (int i = 0; i < postProcessors.length; ++i) {
                postProcessors[i].postProcessJaxRpcService(service);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

