/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core.binding;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.BindTarget;

class IndexedBindMarkers
implements BindMarkers {
    private static final AtomicIntegerFieldUpdater<IndexedBindMarkers> COUNTER_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(IndexedBindMarkers.class, "counter");
    private final int offset;
    private final String prefix;
    private volatile int counter = 0;

    IndexedBindMarkers(String prefix, int beginIndex) {
        this.prefix = prefix;
        this.offset = beginIndex;
    }

    @Override
    public BindMarker next() {
        int index = COUNTER_INCREMENTER.getAndIncrement(this);
        return new IndexedBindMarker(this.prefix + (index + this.offset), index);
    }

    static class IndexedBindMarker
    implements BindMarker {
        private final String placeholder;
        private final int index;

        IndexedBindMarker(String placeholder, int index) {
            this.placeholder = placeholder;
            this.index = index;
        }

        @Override
        public String getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public void bind(BindTarget target, Object value) {
            target.bind(this.index, value);
        }

        @Override
        public void bindNull(BindTarget target, Class<?> valueType) {
            target.bindNull(this.index, valueType);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

