/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.r2dbc.core.BindParameterSource;
import org.springframework.r2dbc.core.ParsedSql;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;

abstract class NamedParameterUtils {
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*", "`"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/", "`"};
    private static final String PARAMETER_SEPARATORS = "\"':&,;()|=+-*%/\\<>^";
    private static final boolean[] separatorIndex = new boolean[128];

    NamedParameterUtils() {
    }

    public static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        HashSet<String> namedParameters = new HashSet<String>();
        StringBuilder sqlToUse = new StringBuilder(sql);
        ArrayList<ParameterHolder> parameterList = new ArrayList<ParameterHolder>();
        char[] statement = sql.toCharArray();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        int escapes = 0;
        int i = 0;
        while (i < statement.length) {
            int j;
            int skipToPosition = i;
            while (i < statement.length && i != (skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i))) {
                i = skipToPosition;
            }
            if (i >= statement.length) break;
            char c = statement[i];
            if (c == ':' || c == '&') {
                if (c == ':' && j < statement.length && statement[j] == ':') {
                    i += 2;
                    continue;
                }
                String parameter = null;
                if (c == ':' && j < statement.length && statement[j] == '{') {
                    while (statement[j] != '}') {
                        if (++j >= statement.length) {
                            throw new InvalidDataAccessApiUsageException("Non-terminated named parameter declaration at position " + i + " in statement: " + sql);
                        }
                        if (statement[j] != ':' && statement[j] != '{') continue;
                        throw new InvalidDataAccessApiUsageException("Parameter name contains invalid character '" + statement[j] + "' at position " + i + " in statement: " + sql);
                    }
                    if (j - i > 2) {
                        parameter = sql.substring(i + 2, j);
                        namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                        totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j + 1, parameter);
                    }
                    ++j;
                } else {
                    boolean paramWithSquareBrackets = false;
                    for (j = i + 1; j < statement.length && !NamedParameterUtils.isParameterSeparator(c = statement[j]); ++j) {
                        if (c == '[') {
                            paramWithSquareBrackets = true;
                            continue;
                        }
                        if (c != ']') continue;
                        if (!paramWithSquareBrackets) break;
                        paramWithSquareBrackets = false;
                    }
                    if (j - i > 1) {
                        parameter = sql.substring(i + 1, j);
                        namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                        totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j, parameter);
                    }
                }
                i = j - 1;
            } else if (c == '\\' && (j = i + 1) < statement.length && statement[j] == ':') {
                sqlToUse.deleteCharAt(i - escapes);
                ++escapes;
                i += 2;
                continue;
            }
            ++i;
        }
        ParsedSql parsedSql = new ParsedSql(sqlToUse.toString());
        for (ParameterHolder ph : parameterList) {
            parsedSql.addNamedParameter(ph.getParameterName(), ph.getStartIndex(), ph.getEndIndex());
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int addNamedParameter(List<ParameterHolder> parameterList, int totalParameterCount, int escapes, int i, int j, String parameter) {
        parameterList.add(new ParameterHolder(parameter, i - escapes, j - escapes));
        return ++totalParameterCount;
    }

    private static int addNewNamedParameter(Set<String> namedParameters, int namedParameterCount, String parameter) {
        if (!namedParameters.contains(parameter)) {
            namedParameters.add(parameter);
            ++namedParameterCount;
        }
        return namedParameterCount;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    public static PreparedOperation<String> substituteNamedParameters(ParsedSql parsedSql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        NamedParameters markerHolder = new NamedParameters(bindMarkersFactory);
        String originalSql = parsedSql.getOriginalSql();
        List<String> paramNames = parsedSql.getParameterNames();
        if (paramNames.isEmpty()) {
            return new ExpandedQuery(originalSql, markerHolder, paramSource);
        }
        StringBuilder actualSql = new StringBuilder(originalSql.length());
        int lastIndex = 0;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql, lastIndex, startIndex);
            NamedParameters.NamedParameter marker = markerHolder.getOrCreate(paramName);
            if (paramSource.hasValue(paramName)) {
                Parameter parameter = paramSource.getValue(paramName);
                Object object = parameter.getValue();
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    int k = 0;
                    int counter = 0;
                    for (Object entryItem : collection) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append('(');
                            for (int m = 0; m < expressionList.length; ++m) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append(marker.getPlaceholder(counter));
                                ++counter;
                            }
                            actualSql.append(')');
                            continue;
                        }
                        actualSql.append(marker.getPlaceholder(counter));
                        ++counter;
                    }
                } else {
                    actualSql.append(marker.getPlaceholder());
                }
            } else {
                actualSql.append(marker.getPlaceholder());
            }
            lastIndex = endIndex;
        }
        actualSql.append(originalSql, lastIndex, originalSql.length());
        return new ExpandedQuery(actualSql.toString(), markerHolder, paramSource);
    }

    private static boolean isParameterSeparator(char c) {
        return c < '\u0080' && separatorIndex[c] || Character.isWhitespace(c);
    }

    public static PreparedOperation<String> substituteNamedParameters(String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, bindMarkersFactory, paramSource);
    }

    static {
        for (char c : PARAMETER_SEPARATORS.toCharArray()) {
            NamedParameterUtils.separatorIndex[c] = true;
        }
    }

    private static class ParameterHolder {
        private final String parameterName;
        private final int startIndex;
        private final int endIndex;

        ParameterHolder(String parameterName, int startIndex, int endIndex) {
            Assert.notNull((Object)parameterName, (String)"Parameter name must not be null");
            this.parameterName = parameterName;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        String getParameterName() {
            return this.parameterName;
        }

        int getStartIndex() {
            return this.startIndex;
        }

        int getEndIndex() {
            return this.endIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof ParameterHolder)) return false;
            ParameterHolder that = (ParameterHolder)other;
            if (this.startIndex != that.startIndex) return false;
            if (this.endIndex != that.endIndex) return false;
            if (!this.parameterName.equals(that.parameterName)) return false;
            return true;
        }

        public int hashCode() {
            return this.parameterName.hashCode();
        }
    }

    static class NamedParameters {
        private final BindMarkers bindMarkers;
        private final boolean identifiable;
        private final Map<String, List<NamedParameter>> references = new TreeMap<String, List<NamedParameter>>();

        NamedParameters(BindMarkersFactory factory) {
            this.bindMarkers = factory.create();
            this.identifiable = factory.identifiablePlaceholders();
        }

        NamedParameter getOrCreate(String namedParameter) {
            List reference = this.references.computeIfAbsent(namedParameter, key -> new ArrayList());
            if (reference.isEmpty()) {
                NamedParameter param = new NamedParameter(namedParameter);
                reference.add(param);
                return param;
            }
            if (this.identifiable) {
                return (NamedParameter)reference.get(0);
            }
            NamedParameter param = new NamedParameter(namedParameter);
            reference.add(param);
            return param;
        }

        @Nullable List<NamedParameter> getMarker(String name) {
            return this.references.get(name);
        }

        class NamedParameter {
            private final String namedParameter;
            private final List<BindMarker> placeholders = new ArrayList<BindMarker>();

            NamedParameter(String namedParameter) {
                this.namedParameter = namedParameter;
            }

            String addPlaceholder() {
                BindMarker bindMarker = NamedParameters.this.bindMarkers.next(this.namedParameter);
                this.placeholders.add(bindMarker);
                return bindMarker.getPlaceholder();
            }

            String getPlaceholder() {
                return this.getPlaceholder(0);
            }

            String getPlaceholder(int counter) {
                while (counter + 1 > this.placeholders.size()) {
                    this.addPlaceholder();
                }
                return this.placeholders.get(counter).getPlaceholder();
            }
        }
    }

    private static class ExpandedQuery
    implements PreparedOperation<String> {
        private final String expandedSql;
        private final NamedParameters parameters;
        private final BindParameterSource parameterSource;

        ExpandedQuery(String expandedSql, NamedParameters parameters, BindParameterSource parameterSource) {
            this.expandedSql = expandedSql;
            this.parameters = parameters;
            this.parameterSource = parameterSource;
        }

        public void bind(BindTarget target, String identifier, Parameter parameter) {
            List<BindMarker> bindMarkers = this.getBindMarkers(identifier);
            if (bindMarkers == null) {
                target.bind(identifier, (Object)parameter);
                return;
            }
            Iterator<BindMarker> iterator = parameter.getValue();
            if (iterator instanceof Collection) {
                Collection collection = (Collection)((Object)iterator);
                Iterator iterator2 = collection.iterator();
                Iterator<BindMarker> markers = bindMarkers.iterator();
                while (iterator2.hasNext()) {
                    Object valueToBind = iterator2.next();
                    if (valueToBind instanceof Object[]) {
                        Object[] objects;
                        for (Object object : objects = (Object[])valueToBind) {
                            this.bind(target, markers, object);
                        }
                        continue;
                    }
                    this.bind(target, markers, valueToBind);
                }
            } else {
                for (BindMarker bindMarker : bindMarkers) {
                    bindMarker.bind(target, parameter);
                }
            }
        }

        private void bind(BindTarget target, Iterator<BindMarker> markers, Object valueToBind) {
            Assert.isTrue((boolean)markers.hasNext(), () -> String.format("No bind marker for value [%s] in SQL [%s]. Check that the query was expanded using the same arguments.", valueToBind, this.toQuery()));
            markers.next().bind(target, valueToBind);
        }

        public void bindNull(BindTarget target, String identifier, Parameter parameter) {
            List<BindMarker> bindMarkers = this.getBindMarkers(identifier);
            if (bindMarkers == null) {
                target.bind(identifier, (Object)parameter);
                return;
            }
            for (BindMarker bindMarker : bindMarkers) {
                bindMarker.bind(target, parameter);
            }
        }

        @Nullable List<BindMarker> getBindMarkers(String identifier) {
            List<NamedParameters.NamedParameter> parameters = this.parameters.getMarker(identifier);
            if (parameters == null) {
                return null;
            }
            ArrayList<BindMarker> markers = new ArrayList<BindMarker>();
            for (NamedParameters.NamedParameter parameter : parameters) {
                markers.addAll(parameter.placeholders);
            }
            return markers;
        }

        @Override
        public String getSource() {
            return this.expandedSql;
        }

        @Override
        public void bindTo(BindTarget target) {
            for (String namedParameter : this.parameterSource.getParameterNames()) {
                Parameter parameter = this.parameterSource.getValue(namedParameter);
                if (parameter.getValue() == null) {
                    this.bindNull(target, namedParameter, parameter);
                    continue;
                }
                this.bind(target, namedParameter, parameter);
            }
        }

        @Override
        public String toQuery() {
            return this.expandedSql;
        }
    }
}

