/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import org.springframework.r2dbc.connection.ConnectionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class R2dbcTransactionManager
extends AbstractReactiveTransactionManager
implements InitializingBean {
    @Nullable
    private ConnectionFactory connectionFactory;
    private boolean enforceReadOnly = false;

    public R2dbcTransactionManager() {
    }

    public R2dbcTransactionManager(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(@Nullable ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Nullable
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected ConnectionFactory obtainConnectionFactory() {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        Assert.state((connectionFactory != null ? 1 : 0) != 0, (String)"No ConnectionFactory set");
        return connectionFactory;
    }

    public void setEnforceReadOnly(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public boolean isEnforceReadOnly() {
        return this.enforceReadOnly;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) {
        ConnectionFactoryTransactionObject txObject = new ConnectionFactoryTransactionObject();
        ConnectionHolder conHolder = (ConnectionHolder)((Object)synchronizationManager.getResource((Object)this.obtainConnectionFactory()));
        txObject.setConnectionHolder(conHolder, false);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((ConnectionFactoryTransactionObject)transaction).isTransactionActive();
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transaction, TransactionDefinition definition) {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
        if (definition.getPropagationBehavior() == 6 && txObject.isTransactionActive()) {
            return txObject.createSavepoint();
        }
        return Mono.defer(() -> {
            Mono connectionMono;
            if (!txObject.hasConnectionHolder() || txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                Mono newCon = Mono.from((Publisher)this.obtainConnectionFactory().create());
                connectionMono = newCon.doOnNext(connection -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Acquired Connection [" + connection + "] for R2DBC transaction"));
                    }
                    txObject.setConnectionHolder(new ConnectionHolder((Connection)connection), true);
                });
            } else {
                txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
                connectionMono = Mono.just((Object)txObject.getConnectionHolder().getConnection());
            }
            return connectionMono.flatMap(con -> this.doBegin((Connection)con, txObject, definition).then(this.prepareTransactionalConnection((Connection)con, definition)).doOnSuccess(v -> {
                txObject.getConnectionHolder().setTransactionActive(true);
                Duration timeout = this.determineTimeout(definition);
                if (!timeout.isNegative() && !timeout.isZero()) {
                    txObject.getConnectionHolder().setTimeoutInMillis(timeout.toMillis());
                }
                if (txObject.isNewConnectionHolder()) {
                    synchronizationManager.bindResource((Object)this.obtainConnectionFactory(), (Object)txObject.getConnectionHolder());
                }
            }).thenReturn(con).onErrorResume(ex -> {
                if (txObject.isNewConnectionHolder()) {
                    return ConnectionFactoryUtils.releaseConnection(con, this.obtainConnectionFactory()).doOnTerminate(() -> txObject.setConnectionHolder(null, false)).then(Mono.error((Throwable)ex));
                }
                return Mono.error((Throwable)ex);
            })).onErrorResume(ex -> Mono.error((Throwable)new CannotCreateTransactionException("Could not open R2DBC Connection for transaction", ex)));
        }).then();
    }

    private Mono<Void> doBegin(Connection con, ConnectionFactoryTransactionObject transaction, TransactionDefinition definition) {
        transaction.setMustRestoreAutoCommit(con.isAutoCommit());
        io.r2dbc.spi.TransactionDefinition transactionDefinition = this.createTransactionDefinition(definition);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting R2DBC transaction on Connection [" + con + "] using [" + transactionDefinition + "]"));
        }
        return Mono.from((Publisher)con.beginTransaction(transactionDefinition));
    }

    protected io.r2dbc.spi.TransactionDefinition createTransactionDefinition(TransactionDefinition definition) {
        IsolationLevel isolationLevelToUse = this.resolveIsolationLevel(definition.getIsolationLevel());
        return new ExtendedTransactionDefinition(definition.getName(), definition.isReadOnly(), (IsolationLevel)(definition.getIsolationLevel() != -1 ? isolationLevelToUse : null), this.determineTimeout(definition));
    }

    protected Duration determineTimeout(TransactionDefinition definition) {
        if (definition.getTimeout() != -1) {
            return Duration.ofSeconds(definition.getTimeout());
        }
        return Duration.ZERO;
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        return Mono.defer(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
            txObject.setConnectionHolder(null);
            return Mono.justOrEmpty((Object)synchronizationManager.unbindResource((Object)this.obtainConnectionFactory()));
        });
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, @Nullable Object transaction, Object suspendedResources) {
        return Mono.defer(() -> {
            synchronizationManager.bindResource((Object)this.obtainConnectionFactory(), suspendedResources);
            return Mono.empty();
        });
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager TransactionSynchronizationManager2, GenericReactiveTransaction status) {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing R2DBC transaction on Connection [" + txObject.getConnectionHolder().getConnection() + "]"));
        }
        return txObject.commit().onErrorMap(R2dbcException.class, ex -> this.translateException("R2DBC commit", (R2dbcException)((Object)ex)));
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager TransactionSynchronizationManager2, GenericReactiveTransaction status) {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back R2DBC transaction on Connection [" + txObject.getConnectionHolder().getConnection() + "]"));
        }
        return txObject.rollback().onErrorMap(R2dbcException.class, ex -> this.translateException("R2DBC rollback", (R2dbcException)((Object)ex)));
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) {
        return Mono.fromRunnable(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
            if (status.isDebug()) {
                this.logger.debug((Object)("Setting R2DBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
            }
            txObject.setRollbackOnly();
        });
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        return Mono.defer(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
            if (txObject.hasSavepoint()) {
                return txObject.releaseSavepoint();
            }
            if (txObject.isNewConnectionHolder()) {
                synchronizationManager.unbindResource((Object)this.obtainConnectionFactory());
            }
            try {
                if (txObject.isNewConnectionHolder()) {
                    Connection con = txObject.getConnectionHolder().getConnection();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Releasing R2DBC Connection [" + con + "] after transaction"));
                    }
                    Mono restoreMono = Mono.empty();
                    if (txObject.isMustRestoreAutoCommit() && !con.isAutoCommit()) {
                        restoreMono = Mono.from((Publisher)con.setAutoCommit(true));
                        if (this.logger.isDebugEnabled()) {
                            restoreMono = restoreMono.doOnError(ex -> this.logger.debug((Object)String.format("Error ignored during auto-commit restore: %s", ex)));
                        }
                        restoreMono = restoreMono.onErrorComplete();
                    }
                    Mono releaseMono = ConnectionFactoryUtils.releaseConnection(con, this.obtainConnectionFactory());
                    if (this.logger.isDebugEnabled()) {
                        releaseMono = releaseMono.doOnError(ex -> this.logger.debug((Object)String.format("Error ignored during connection release: %s", ex)));
                    }
                    releaseMono = releaseMono.onErrorComplete();
                    Mono mono = restoreMono.then(releaseMono);
                    return mono;
                }
            }
            finally {
                txObject.getConnectionHolder().clear();
            }
            return Mono.empty();
        });
    }

    protected Mono<Void> prepareTransactionalConnection(Connection con, TransactionDefinition definition) {
        Mono prepare = Mono.empty();
        if (this.isEnforceReadOnly() && definition.isReadOnly()) {
            prepare = Mono.from((Publisher)con.createStatement("SET TRANSACTION READ ONLY").execute()).flatMapMany(Result::getRowsUpdated).then();
        }
        return prepare;
    }

    @Nullable
    protected IsolationLevel resolveIsolationLevel(int isolationLevel) {
        return switch (isolationLevel) {
            case 2 -> IsolationLevel.READ_COMMITTED;
            case 1 -> IsolationLevel.READ_UNCOMMITTED;
            case 4 -> IsolationLevel.REPEATABLE_READ;
            case 8 -> IsolationLevel.SERIALIZABLE;
            default -> null;
        };
    }

    protected RuntimeException translateException(String task, R2dbcException ex) {
        return ConnectionFactoryUtils.convertR2dbcException(task, null, ex);
    }

    private static class ConnectionFactoryTransactionObject {
        @Nullable
        private ConnectionHolder connectionHolder;
        private boolean newConnectionHolder;
        private boolean mustRestoreAutoCommit;
        @Nullable
        private String savepointName;

        private ConnectionFactoryTransactionObject() {
        }

        void setConnectionHolder(@Nullable ConnectionHolder connectionHolder, boolean newConnectionHolder) {
            this.setConnectionHolder(connectionHolder);
            this.newConnectionHolder = newConnectionHolder;
        }

        boolean isNewConnectionHolder() {
            return this.newConnectionHolder;
        }

        public void setConnectionHolder(@Nullable ConnectionHolder connectionHolder) {
            this.connectionHolder = connectionHolder;
        }

        public ConnectionHolder getConnectionHolder() {
            Assert.state((this.connectionHolder != null ? 1 : 0) != 0, (String)"No ConnectionHolder available");
            return this.connectionHolder;
        }

        public boolean hasConnectionHolder() {
            return this.connectionHolder != null;
        }

        public void setMustRestoreAutoCommit(boolean mustRestoreAutoCommit) {
            this.mustRestoreAutoCommit = mustRestoreAutoCommit;
        }

        public boolean isMustRestoreAutoCommit() {
            return this.mustRestoreAutoCommit;
        }

        public boolean isTransactionActive() {
            return this.connectionHolder != null && this.connectionHolder.isTransactionActive();
        }

        public boolean hasSavepoint() {
            return this.savepointName != null;
        }

        public Mono<Void> createSavepoint() {
            String currentSavepoint;
            ConnectionHolder holder = this.getConnectionHolder();
            this.savepointName = currentSavepoint = holder.nextSavepoint();
            return Mono.from((Publisher)holder.getConnection().createSavepoint(currentSavepoint));
        }

        public Mono<Void> releaseSavepoint() {
            String currentSavepoint = this.savepointName;
            if (currentSavepoint == null) {
                return Mono.empty();
            }
            this.savepointName = null;
            return Mono.from((Publisher)this.getConnectionHolder().getConnection().releaseSavepoint(currentSavepoint));
        }

        public Mono<Void> commit() {
            return this.hasSavepoint() ? Mono.empty() : Mono.from((Publisher)this.getConnectionHolder().getConnection().commitTransaction());
        }

        public Mono<Void> rollback() {
            Connection connection = this.getConnectionHolder().getConnection();
            String currentSavepoint = this.savepointName;
            return currentSavepoint != null ? Mono.from((Publisher)connection.rollbackTransactionToSavepoint(currentSavepoint)) : Mono.from((Publisher)connection.rollbackTransaction());
        }

        public void setRollbackOnly() {
            this.getConnectionHolder().setRollbackOnly();
        }
    }

    private record ExtendedTransactionDefinition(@Nullable String transactionName, boolean readOnly, @Nullable IsolationLevel isolationLevel, Duration lockWaitTimeout) implements io.r2dbc.spi.TransactionDefinition
    {
        public <T> T getAttribute(Option<T> option) {
            return (T)this.doGetValue(option);
        }

        @Nullable
        private Object doGetValue(Option<?> option) {
            if (io.r2dbc.spi.TransactionDefinition.ISOLATION_LEVEL.equals(option)) {
                return this.isolationLevel;
            }
            if (io.r2dbc.spi.TransactionDefinition.NAME.equals(option)) {
                return this.transactionName;
            }
            if (io.r2dbc.spi.TransactionDefinition.READ_ONLY.equals(option)) {
                return this.readOnly;
            }
            if (io.r2dbc.spi.TransactionDefinition.LOCK_WAIT_TIMEOUT.equals(option) && !this.lockWaitTimeout.isZero()) {
                return this.lockWaitTimeout;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append(this.getClass().getSimpleName());
            sb.append(" [transactionName='").append(this.transactionName).append('\'');
            sb.append(", readOnly=").append(this.readOnly);
            sb.append(", isolationLevel=").append(this.isolationLevel);
            sb.append(", lockWaitTimeout=").append(this.lockWaitTimeout);
            sb.append(']');
            return sb.toString();
        }
    }
}

