/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.FetchType;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class MutablePersistenceUnitInfo {
    private @Nullable String persistenceUnitName;
    private @Nullable String persistenceProviderClassName;
    private @Nullable PersistenceUnitTransactionType transactionType;
    private @Nullable DataSource jtaDataSource;
    private @Nullable DataSource nonJtaDataSource;
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final List<URL> jarFileUrls = new ArrayList<URL>();
    private @Nullable URL persistenceUnitRootUrl;
    private final List<String> managedClassNames = new ArrayList<String>();
    private final List<String> managedPackages = new ArrayList<String>();
    private boolean excludeUnlistedClasses = false;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;
    private FetchType defaultToOneFetchType = FetchType.EAGER;
    private Properties properties = new Properties();
    private String persistenceXMLSchemaVersion = "3.2";
    private @Nullable String persistenceProviderPackageName;

    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public @Nullable String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceProviderClassName(@Nullable String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public @Nullable String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        if (this.transactionType != null) {
            return this.transactionType;
        }
        return this.jtaDataSource != null ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    public void setJtaDataSource(@Nullable DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public @Nullable DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setNonJtaDataSource(@Nullable DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public @Nullable DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void addMappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public void addJarFileUrl(URL jarFileUrl) {
        this.jarFileUrls.add(jarFileUrl);
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public void setPersistenceUnitRootUrl(@Nullable URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public @Nullable URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void addManagedClassName(String managedClassName) {
        this.managedClassNames.add(managedClassName);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void addManagedPackage(String packageName) {
        this.managedPackages.add(packageName);
    }

    public List<String> getManagedPackages() {
        return this.managedPackages;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setDefaultToOneFetchType(FetchType defaultToOneFetchType) {
        this.defaultToOneFetchType = defaultToOneFetchType;
    }

    public FetchType getDefaultToOneFetchType() {
        return this.defaultToOneFetchType;
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setProperties(Properties properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setPersistenceXMLSchemaVersion(String persistenceXMLSchemaVersion) {
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public void setPersistenceProviderPackageName(@Nullable String persistenceProviderPackageName) {
        this.persistenceProviderPackageName = persistenceProviderPackageName;
    }

    public @Nullable String getPersistenceProviderPackageName() {
        return this.persistenceProviderPackageName;
    }

    public String toString() {
        return "PersistenceUnitInfo: name '" + this.persistenceUnitName + "', root URL [" + String.valueOf(this.persistenceUnitRootUrl) + "]";
    }
}

