/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FetchType;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.SingleDataSourceLookup;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.ManagedClassNameFilter;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LocalContainerEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware,
LoadTimeWeaverAware {
    private @Nullable PersistenceUnitManager persistenceUnitManager;
    private final DefaultPersistenceUnitManager internalPersistenceUnitManager = new DefaultPersistenceUnitManager();
    private @Nullable PersistenceUnitInfo persistenceUnitInfo;

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.internalPersistenceUnitManager.setPersistenceXmlLocation(persistenceXmlLocation);
    }

    @Override
    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        super.setPersistenceUnitName(persistenceUnitName);
        if (persistenceUnitName != null) {
            this.internalPersistenceUnitManager.setDefaultPersistenceUnitName(persistenceUnitName);
        }
    }

    public void setPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        this.internalPersistenceUnitManager.setDefaultPersistenceUnitRootLocation(defaultPersistenceUnitRootLocation);
    }

    public void setPersistenceConfiguration(PersistenceConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"PersistenceConfiguration must not be null");
        super.setPersistenceUnitName(configuration.name());
        this.internalPersistenceUnitManager.setPersistenceConfiguration(configuration);
    }

    public void setManagedTypes(PersistenceManagedTypes managedTypes) {
        this.internalPersistenceUnitManager.setManagedTypes(managedTypes);
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.internalPersistenceUnitManager.setPackagesToScan(packagesToScan);
    }

    public void setManagedClassNameFilter(ManagedClassNameFilter managedClassNameFilter) {
        this.internalPersistenceUnitManager.setManagedClassNameFilter(managedClassNameFilter);
    }

    public void setMappingResources(String ... mappingResources) {
        this.internalPersistenceUnitManager.setMappingResources(mappingResources);
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.internalPersistenceUnitManager.setSharedCacheMode(sharedCacheMode);
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.internalPersistenceUnitManager.setValidationMode(validationMode);
    }

    public void setDefaultToOneFetchType(FetchType defaultToOneFetchType) {
        this.internalPersistenceUnitManager.setDefaultToOneFetchType(defaultToOneFetchType);
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)(dataSource != null ? new SingleDataSourceLookup(dataSource) : null));
        this.internalPersistenceUnitManager.setDefaultDataSource(dataSource);
    }

    public void setJtaDataSource(@Nullable DataSource jtaDataSource) {
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)(jtaDataSource != null ? new SingleDataSourceLookup(jtaDataSource) : null));
        this.internalPersistenceUnitManager.setDefaultJtaDataSource(jtaDataSource);
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.internalPersistenceUnitManager.setPersistenceUnitPostProcessors(postProcessors);
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.internalPersistenceUnitManager.setLoadTimeWeaver(loadTimeWeaver);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.internalPersistenceUnitManager.setResourceLoader(resourceLoader);
    }

    @Override
    public void afterPropertiesSet() throws PersistenceException {
        List qualifiers;
        String scope;
        PersistenceUnitInfo persistenceUnitInfo;
        PersistenceUnitManager managerToUse = this.persistenceUnitManager;
        if (managerToUse == null) {
            this.internalPersistenceUnitManager.afterPropertiesSet();
            managerToUse = this.internalPersistenceUnitManager;
        }
        this.persistenceUnitInfo = this.determinePersistenceUnitInfo(managerToUse);
        JpaVendorAdapter jpaVendorAdapter = this.getJpaVendorAdapter();
        if (jpaVendorAdapter != null && (persistenceUnitInfo = this.persistenceUnitInfo) instanceof SmartPersistenceUnitInfo) {
            SmartPersistenceUnitInfo smartInfo = (SmartPersistenceUnitInfo)persistenceUnitInfo;
            String rootPackage = jpaVendorAdapter.getPersistenceProviderRootPackage();
            if (rootPackage != null) {
                smartInfo.setPersistenceProviderPackageName(rootPackage);
            }
        }
        if (StringUtils.hasText((String)(scope = this.persistenceUnitInfo.getScopeAnnotationName()))) {
            this.logger.info((Object)("Scope annotation name for persistence unit ignored by Spring: " + scope));
        }
        if (!CollectionUtils.isEmpty((Collection)(qualifiers = this.persistenceUnitInfo.getQualifierAnnotationNames()))) {
            BeanFactory beanFactory = this.getBeanFactory();
            String beanName = this.getBeanName();
            if (beanFactory instanceof ConfigurableBeanFactory) {
                BeanDefinition bd;
                ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
                if (beanName != null && (bd = cbf.getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition) {
                    AbstractBeanDefinition abd = (AbstractBeanDefinition)bd;
                    for (String qualifier : qualifiers) {
                        abd.addQualifier(new AutowireCandidateQualifier(qualifier));
                    }
                }
            }
        }
        super.afterPropertiesSet();
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        Assert.state((this.persistenceUnitInfo != null ? 1 : 0) != 0, (String)"PersistenceUnitInfo not initialized");
        PersistenceProvider provider = this.getPersistenceProvider();
        if (provider == null) {
            String providerClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
            if (providerClassName == null) {
                throw new IllegalArgumentException("No PersistenceProvider specified in EntityManagerFactory configuration, and chosen PersistenceUnitInfo does not specify a provider class name either");
            }
            Class providerClass = ClassUtils.resolveClassName((String)providerClassName, (ClassLoader)this.getBeanClassLoader());
            provider = (PersistenceProvider)BeanUtils.instantiateClass((Class)providerClass);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Building JPA container EntityManagerFactory for persistence unit '" + this.persistenceUnitInfo.getPersistenceUnitName() + "'"));
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(this.persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(emf, this.persistenceUnitInfo);
        return emf;
    }

    protected PersistenceUnitInfo determinePersistenceUnitInfo(PersistenceUnitManager persistenceUnitManager) {
        String persistenceUnitName = this.getPersistenceUnitName();
        if (persistenceUnitName != null) {
            return persistenceUnitManager.obtainPersistenceUnitInfo(persistenceUnitName);
        }
        return persistenceUnitManager.obtainDefaultPersistenceUnitInfo();
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
    }

    @Override
    public @Nullable PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    @Override
    public @Nullable String getPersistenceUnitName() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getPersistenceUnitName();
        }
        return super.getPersistenceUnitName();
    }

    @Override
    public @Nullable DataSource getDataSource() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getJtaDataSource() != null ? this.persistenceUnitInfo.getJtaDataSource() : this.persistenceUnitInfo.getNonJtaDataSource();
        }
        return this.internalPersistenceUnitManager.getDefaultJtaDataSource() != null ? this.internalPersistenceUnitManager.getDefaultJtaDataSource() : this.internalPersistenceUnitManager.getDefaultDataSource();
    }
}

