/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.Ordered;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaObjectRetrievalFailureException;
import org.springframework.orm.jpa.JpaOptimisticLockingFailureException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class EntityManagerFactoryUtils {
    public static final int ENTITY_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final @Nullable Method CREATE_ENTITY_AGENT_METHOD = ClassUtils.getMethodIfAvailable(EntityManagerFactory.class, (String)"createEntityAgent", (Class[])new Class[0]);
    private static final @Nullable Method CREATE_ENTITY_AGENT_WITH_PROPERTIES_METHOD = ClassUtils.getMethodIfAvailable(EntityManagerFactory.class, (String)"createEntityAgent", (Class[])new Class[]{Map.class});
    private static final Log logger = LogFactory.getLog(EntityManagerFactoryUtils.class);

    public static EntityManagerFactory findEntityManagerFactory(ListableBeanFactory beanFactory, @Nullable String unitName) throws NoSuchBeanDefinitionException {
        Assert.notNull((Object)beanFactory, (String)"ListableBeanFactory must not be null");
        if (StringUtils.hasLength((String)unitName)) {
            String[] candidateNames;
            for (String candidateName : candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EntityManagerFactory.class)) {
                EntityManagerFactoryInfo emfInfo;
                EntityManagerFactory emf = (EntityManagerFactory)beanFactory.getBean(candidateName);
                if (!(emf instanceof EntityManagerFactoryInfo) || !unitName.equals((emfInfo = (EntityManagerFactoryInfo)emf).getPersistenceUnitName())) continue;
                return emf;
            }
            return (EntityManagerFactory)beanFactory.getBean(unitName, EntityManagerFactory.class);
        }
        return (EntityManagerFactory)beanFactory.getBean(EntityManagerFactory.class);
    }

    public static @Nullable EntityManager getTransactionalEntityManager(EntityManagerFactory emf) throws DataAccessResourceFailureException {
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, null);
    }

    public static @Nullable EntityManager getTransactionalEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties) throws DataAccessResourceFailureException {
        try {
            return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties, true);
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not obtain JPA EntityManager", (Throwable)ex);
        }
    }

    public static @Nullable EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, Map<?, ?> properties) throws PersistenceException {
        return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @Nullable EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction) throws PersistenceException {
        Assert.notNull((Object)emf, (String)"No EntityManagerFactory specified");
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)emf));
        if (emHolder != null && emHolder.hasEntityManager()) {
            if (synchronizedWithTransaction) {
                if (!emHolder.isSynchronizedWithTransaction()) {
                    if (TransactionSynchronizationManager.isActualTransactionActive()) {
                        try {
                            emHolder.getEntityManager().joinTransaction();
                        }
                        catch (TransactionRequiredException ex) {
                            logger.debug((Object)"Could not join transaction because none was actually active", (Throwable)ex);
                        }
                    }
                    if (TransactionSynchronizationManager.isSynchronizationActive()) {
                        Object transactionData = EntityManagerFactoryUtils.prepareTransaction(emHolder.getEntityManager(), emf);
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionalEntityManagerSynchronization(emHolder, emf, transactionData, false));
                        emHolder.setSynchronizedWithTransaction(true);
                    }
                }
                emHolder.requested();
                return emHolder.getEntityManager();
            }
            if (!emHolder.isTransactionActive() || emHolder.isOpen()) return emHolder.getEntityManager();
            if (!TransactionSynchronizationManager.isSynchronizationActive()) {
                return null;
            }
            TransactionSynchronizationManager.unbindResource((Object)emf);
            emHolder = null;
        } else if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        logger.debug((Object)"Opening JPA EntityManager");
        EntityManager em = null;
        if (!synchronizedWithTransaction) {
            try {
                em = emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED, properties);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        if (em == null) {
            em = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        }
        try {
            if (emHolder != null) {
                emHolder.setEntityManager(em);
                Object transactionData = EntityManagerFactoryUtils.prepareTransaction(em, emf);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionalEntityManagerSynchronization(emHolder, emf, transactionData, false));
                emHolder.setSynchronizedWithTransaction(true);
                return em;
            } else {
                emHolder = new EntityManagerHolder(em);
                if (synchronizedWithTransaction) {
                    Object transactionData = EntityManagerFactoryUtils.prepareTransaction(em, emf);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionalEntityManagerSynchronization(emHolder, emf, transactionData, true));
                    emHolder.setSynchronizedWithTransaction(true);
                } else {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionScopedEntityManagerSynchronization(emHolder, emf));
                }
                TransactionSynchronizationManager.bindResource((Object)emf, (Object)((Object)emHolder));
            }
            return em;
        }
        catch (RuntimeException ex) {
            EntityManagerFactoryUtils.closeEntityManager(em);
            throw ex;
        }
    }

    static @Nullable Object doGetTransactionalEntityAgent(EntityManagerFactory emf, @Nullable Map<?, ?> properties) throws PersistenceException {
        EntityManagerFactoryInfo info;
        JpaDialect jpaDialect;
        Assert.notNull((Object)emf, (String)"No EntityManagerFactory specified");
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)emf));
        if (emHolder != null) {
            if (emHolder.hasEntityAgent()) {
                return emHolder.getEntityAgent();
            }
        } else if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        logger.debug((Object)"Opening JPA EntityAgent");
        Object entityAgent = null;
        if (emHolder != null && emf instanceof EntityManagerFactoryInfo && (jpaDialect = (info = (EntityManagerFactoryInfo)emf).getJpaDialect()) instanceof DefaultJpaDialect) {
            DefaultJpaDialect defaultJpaDialect = (DefaultJpaDialect)jpaDialect;
            entityAgent = defaultJpaDialect.deriveEntityAgent(emHolder.getEntityManager(), properties);
        }
        if (entityAgent == null) {
            entityAgent = EntityManagerFactoryUtils.createEntityAgent(emf, properties);
        }
        if (emHolder != null) {
            emHolder.setEntityAgent(entityAgent);
        } else {
            emHolder = new EntityManagerHolder(entityAgent);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionScopedEntityManagerSynchronization(emHolder, emf));
            TransactionSynchronizationManager.bindResource((Object)emf, (Object)((Object)emHolder));
        }
        emHolder.setSynchronizedWithTransaction(true);
        return entityAgent;
    }

    static Object createEntityAgent(EntityManagerFactory emf, @Nullable Map<?, ?> properties) {
        Object entityAgent;
        if (CREATE_ENTITY_AGENT_METHOD == null || CREATE_ENTITY_AGENT_WITH_PROPERTIES_METHOD == null) {
            throw new IllegalStateException("JPA 4.0 createEntityAgent API not available");
        }
        Object object = entityAgent = !CollectionUtils.isEmpty(properties) ? ReflectionUtils.invokeMethod((Method)CREATE_ENTITY_AGENT_WITH_PROPERTIES_METHOD, (Object)emf, (Object[])new Object[]{properties}) : ReflectionUtils.invokeMethod((Method)CREATE_ENTITY_AGENT_METHOD, (Object)emf);
        if (entityAgent == null) {
            throw new IllegalStateException("JPA 4.0 createEntityAgent API returned null");
        }
        return entityAgent;
    }

    static @Nullable Class<?> getEntityAgentClass() {
        return CREATE_ENTITY_AGENT_METHOD != null ? CREATE_ENTITY_AGENT_METHOD.getReturnType() : null;
    }

    private static @Nullable Object prepareTransaction(EntityManager em, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            return jpaDialect.prepareTransaction(em, TransactionSynchronizationManager.isCurrentTransactionReadOnly(), TransactionSynchronizationManager.getCurrentTransactionName());
        }
        return null;
    }

    private static void cleanupTransaction(@Nullable Object transactionData, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            jpaDialect.cleanupTransaction(transactionData);
        }
    }

    public static void applyTransactionTimeout(Query query, EntityManagerFactory emf) {
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)emf));
        if (emHolder != null && emHolder.hasTimeout()) {
            int timeoutValue = (int)emHolder.getTimeToLiveInMillis();
            try {
                query.setHint("jakarta.persistence.query.timeout", (Object)timeoutValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static @Nullable DataAccessException convertJpaAccessExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof EntityNotFoundException) {
            EntityNotFoundException entityNotFoundException = (EntityNotFoundException)ex;
            return new JpaObjectRetrievalFailureException(entityNotFoundException);
        }
        if (ex instanceof NoResultException) {
            return new EmptyResultDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof jakarta.persistence.QueryTimeoutException) {
            return new QueryTimeoutException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof LockTimeoutException) {
            return new CannotAcquireLockException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof OptimisticLockException) {
            OptimisticLockException optimisticLockException = (OptimisticLockException)ex;
            return new JpaOptimisticLockingFailureException(optimisticLockException);
        }
        if (ex instanceof EntityExistsException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransactionRequiredException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistenceException) {
            return new JpaSystemException(ex);
        }
        return null;
    }

    public static void closeEntityManager(@Nullable EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to release JPA EntityManager", ex);
            }
        }
    }

    static void closeEntityHandler(@Nullable Object entityHandler) {
        if (entityHandler instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)entityHandler;
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to close JPA EntityHandler", ex);
            }
        }
    }

    private static class TransactionalEntityManagerSynchronization
    extends ResourceHolderSynchronization<EntityManagerHolder, EntityManagerFactory>
    implements Ordered {
        private final @Nullable Object transactionData;
        private final @Nullable JpaDialect jpaDialect;
        private final boolean newEntityManager;

        public TransactionalEntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf, @Nullable Object txData, boolean newEm) {
            super((ResourceHolder)emHolder, (Object)emf);
            JpaDialect jpaDialect;
            this.transactionData = txData;
            if (emf instanceof EntityManagerFactoryInfo) {
                EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
                jpaDialect = emfInfo.getJpaDialect();
            } else {
                jpaDialect = null;
            }
            this.jpaDialect = jpaDialect;
            this.newEntityManager = newEm;
        }

        public int getOrder() {
            return 900;
        }

        protected void flushResource(EntityManagerHolder resourceHolder) {
            EntityManagerProxy emProxy;
            EntityManager target;
            EntityManager em = resourceHolder.getEntityManager();
            if (em instanceof EntityManagerProxy && TransactionSynchronizationManager.hasResource((Object)(target = (emProxy = (EntityManagerProxy)em).getTargetEntityManager()))) {
                return;
            }
            try {
                em.flush();
            }
            catch (RuntimeException ex) {
                DataAccessException dae = this.jpaDialect != null ? this.jpaDialect.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
                throw dae != null ? dae : ex;
            }
        }

        protected boolean shouldUnbindAtCompletion() {
            return this.newEntityManager;
        }

        protected void releaseResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey) {
            resourceHolder.closeAll();
        }

        protected void cleanupResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey, boolean committed) {
            if (!committed) {
                resourceHolder.getEntityManager().clear();
            }
            EntityManagerFactoryUtils.cleanupTransaction(this.transactionData, resourceKey);
        }
    }

    private static class TransactionScopedEntityManagerSynchronization
    extends ResourceHolderSynchronization<EntityManagerHolder, EntityManagerFactory>
    implements Ordered {
        public TransactionScopedEntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf) {
            super((ResourceHolder)emHolder, (Object)emf);
        }

        public int getOrder() {
            return 901;
        }

        protected void releaseResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey) {
            resourceHolder.closeAll();
        }
    }
}

