/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import jakarta.persistence.EntityManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.util.Assert;

class SessionHolder
extends EntityManagerHolder {
    private @Nullable StatelessSession statelessSession;
    private @Nullable Transaction transaction;
    private @Nullable FlushMode previousFlushMode;

    public SessionHolder(Session session) {
        super((EntityManager)session);
    }

    public SessionHolder(StatelessSession session) {
        super(null);
        this.statelessSession = session;
    }

    public void setSession(Session session) {
        this.entityManager = session;
    }

    public Session getSession() {
        return (Session)this.getEntityManager();
    }

    public boolean hasSession() {
        return this.entityManager != null;
    }

    public void setStatelessSession(StatelessSession statelessSession) {
        this.statelessSession = statelessSession;
    }

    public StatelessSession getStatelessSession() {
        Assert.state((this.statelessSession != null ? 1 : 0) != 0, (String)"No StatelessSession available");
        return this.statelessSession;
    }

    public boolean hasStatelessSession() {
        return this.statelessSession != null;
    }

    public void setTransaction(@Nullable Transaction transaction) {
        this.transaction = transaction;
        this.setTransactionActive(transaction != null);
    }

    public @Nullable Transaction getTransaction() {
        return this.transaction;
    }

    public void setPreviousFlushMode(@Nullable FlushMode previousFlushMode) {
        this.previousFlushMode = previousFlushMode;
    }

    public @Nullable FlushMode getPreviousFlushMode() {
        return this.previousFlushMode;
    }

    @Override
    public void clear() {
        super.clear();
        this.transaction = null;
        this.previousFlushMode = null;
    }

    @Override
    protected void closeAll() {
        super.closeAll();
        if (this.statelessSession != null && this.statelessSession.isOpen()) {
            this.statelessSession.close();
        }
    }
}

