/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransactionException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.SQLExceptionSubclassTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionDefinition;
import org.springframework.util.ReflectionUtils;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    boolean prepareConnection = true;
    private @Nullable SQLExceptionTranslator jdbcExceptionTranslator;
    private @Nullable SQLExceptionTranslator transactionExceptionTranslator = new SQLExceptionSubclassTranslator();

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setJdbcExceptionTranslator(@Nullable SQLExceptionTranslator exceptionTranslator) {
        this.jdbcExceptionTranslator = exceptionTranslator;
        this.transactionExceptionTranslator = exceptionTranslator;
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, org.springframework.transaction.TransactionException {
        ResourceTransactionDefinition rtd;
        SessionImplementor session = this.getSession(entityManager);
        if (definition.getTimeout() != -1) {
            session.getTransaction().setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            if (this.prepareConnection && ConnectionReleaseMode.ON_CLOSE.equals((Object)session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode().getReleaseMode())) {
                preparedCon = session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
                previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)preparedCon, (TransactionDefinition)definition);
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException("HibernateJpaDialect is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to ON_CLOSE.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, definition.isReadOnly());
        if (definition instanceof ResourceTransactionDefinition && (rtd = (ResourceTransactionDefinition)definition).isLocalResource()) {
            previousFlushMode = null;
            if (definition.isReadOnly()) {
                session.setDefaultReadOnly(true);
            }
        }
        return new SessionTransactionData(session, previousFlushMode, preparedCon != null, previousIsolationLevel, definition.isReadOnly());
    }

    @Override
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, @Nullable String name) throws PersistenceException {
        SessionImplementor session = this.getSession(entityManager);
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, readOnly);
        return new SessionTransactionData(session, previousFlushMode, false, null, readOnly);
    }

    protected @Nullable FlushMode prepareFlushMode(Session session, boolean readOnly) throws PersistenceException {
        FlushMode flushMode = session.getHibernateFlushMode();
        if (readOnly) {
            if (!flushMode.equals((Object)FlushMode.MANUAL)) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setHibernateFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    @Override
    public void cleanupTransaction(@Nullable Object transactionData) {
        if (transactionData instanceof SessionTransactionData) {
            SessionTransactionData sessionTransactionData = (SessionTransactionData)transactionData;
            sessionTransactionData.resetSessionState();
        }
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        SessionImplementor session = this.getSession(entityManager);
        return new HibernateConnectionHandle(session);
    }

    @Override
    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        Throwable throwable;
        if (ex instanceof HibernateException) {
            HibernateException hibernateEx = (HibernateException)((Object)ex);
            return this.convertHibernateAccessException(hibernateEx);
        }
        if (ex instanceof PersistenceException && (throwable = ex.getCause()) instanceof HibernateException) {
            HibernateException hibernateEx = (HibernateException)throwable;
            return this.convertHibernateAccessException(hibernateEx);
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        SQLGrammarException hibEx;
        JDBCException jdbcEx;
        Throwable dae;
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException && (dae = this.jdbcExceptionTranslator.translate("Hibernate operation: " + (jdbcEx = (JDBCException)ex).getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException())) != null) {
            return dae;
        }
        if (this.transactionExceptionTranslator != null && ex instanceof TransactionException && (dae = ex.getCause()) instanceof SQLException) {
            SQLException sqlEx = (SQLException)dae;
            dae = this.transactionExceptionTranslator.translate("Hibernate transaction: " + ex.getMessage(), null, sqlEx);
            if (dae != null) {
                return dae;
            }
        }
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            hibEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof org.hibernate.QueryTimeoutException) {
            hibEx = (org.hibernate.QueryTimeoutException)ex;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            hibEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            hibEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            hibEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]; constraint [" + hibEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            hibEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof QueryException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            hibEx = (UnresolvableObjectException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), this.getIdentifier((HibernateException)hibEx), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof WrongClassException) {
            hibEx = (WrongClassException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), this.getIdentifier((HibernateException)hibEx), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            hibEx = (StaleObjectStateException)ex;
            return new ObjectOptimisticLockingFailureException(hibEx.getEntityName(), this.getIdentifier((HibernateException)hibEx), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof StaleStateException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof OptimisticEntityLockException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new JpaSystemException((RuntimeException)((Object)ex));
    }

    protected SessionImplementor getSession(EntityManager entityManager) {
        return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
    }

    protected @Nullable Object getIdentifier(HibernateException hibEx) {
        try {
            return ReflectionUtils.invokeMethod((Method)((Object)((Object)hibEx)).getClass().getMethod("getIdentifier", new Class[0]), (Object)((Object)hibEx));
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static class SessionTransactionData {
        private final SessionImplementor session;
        private final @Nullable FlushMode previousFlushMode;
        private final boolean needsConnectionReset;
        private final @Nullable Integer previousIsolationLevel;
        private final boolean readOnly;

        public SessionTransactionData(SessionImplementor session, @Nullable FlushMode previousFlushMode, boolean connectionPrepared, @Nullable Integer previousIsolationLevel, boolean readOnly) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
            this.needsConnectionReset = connectionPrepared;
            this.previousIsolationLevel = previousIsolationLevel;
            this.readOnly = readOnly;
        }

        public void resetSessionState() {
            if (this.previousFlushMode != null) {
                this.session.setHibernateFlushMode(this.previousFlushMode);
            }
            if (this.needsConnectionReset && this.session.getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected()) {
                Connection con = this.session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)this.previousIsolationLevel, (boolean)this.readOnly);
            }
        }
    }

    private static class HibernateConnectionHandle
    implements ConnectionHandle {
        private final SessionImplementor session;

        public HibernateConnectionHandle(SessionImplementor session) {
            this.session = session;
        }

        public Connection getConnection() {
            return this.session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        }
    }
}

