/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDefinitionFactoryBean
implements FactoryBean<FilterDefinition>,
BeanNameAware,
InitializingBean {
    private static Method heuristicTypeMethod;
    private static Object typeResolver;
    private String filterName;
    private Map<String, Type> parameterTypeMap = new HashMap<String, Type>();
    private String defaultFilterCondition;
    private FilterDefinition filterDefinition;

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setParameterTypes(Map<String, String> parameterTypes) {
        if (parameterTypes != null) {
            this.parameterTypeMap = new HashMap<String, Type>(parameterTypes.size());
            for (Map.Entry<String, String> entry : parameterTypes.entrySet()) {
                this.parameterTypeMap.put(entry.getKey(), (Type)ReflectionUtils.invokeMethod((Method)heuristicTypeMethod, (Object)typeResolver, (Object[])new Object[]{entry.getValue()}));
            }
        } else {
            this.parameterTypeMap = new HashMap<String, Type>();
        }
    }

    public void setDefaultFilterCondition(String defaultFilterCondition) {
        this.defaultFilterCondition = defaultFilterCondition;
    }

    public void setBeanName(String name) {
        if (this.filterName == null) {
            this.filterName = name;
        }
    }

    public void afterPropertiesSet() {
        this.filterDefinition = new FilterDefinition(this.filterName, this.defaultFilterCondition, this.parameterTypeMap);
    }

    public FilterDefinition getObject() {
        return this.filterDefinition;
    }

    public Class<FilterDefinition> getObjectType() {
        return FilterDefinition.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static {
        try {
            Class<?> trClass = FilterDefinitionFactoryBean.class.getClassLoader().loadClass("org.hibernate.type.TypeResolver");
            heuristicTypeMethod = trClass.getMethod("heuristicType", String.class);
            typeResolver = trClass.newInstance();
        }
        catch (Exception ex) {
            try {
                heuristicTypeMethod = TypeFactory.class.getMethod("heuristicType", String.class);
                typeResolver = null;
            }
            catch (Exception ex2) {
                throw new IllegalStateException("Cannot find Hibernate's heuristicType method", ex2);
            }
        }
    }
}

