/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.AbstractSpringContextTests;
import org.springframework.util.StringUtils;

public abstract class AbstractSingleSpringContextTests
extends AbstractSpringContextTests {
    protected ConfigurableApplicationContext applicationContext;
    private int loadCount = 0;

    public AbstractSingleSpringContextTests() {
    }

    public AbstractSingleSpringContextTests(String name) {
        super(name);
    }

    protected final void setUp() throws Exception {
        this.applicationContext = this.getContext(this.contextKey());
        this.prepareTestInstance();
        this.onSetUp();
    }

    protected void prepareTestInstance() throws Exception {
    }

    protected void onSetUp() throws Exception {
    }

    protected void setDirty() {
        this.setDirty(this.contextKey());
    }

    protected final void tearDown() throws Exception {
        this.onTearDown();
    }

    protected void onTearDown() throws Exception {
    }

    protected Object contextKey() {
        return this.getConfigLocations();
    }

    protected ConfigurableApplicationContext loadContext(Object key) throws Exception {
        return this.loadContextLocations((String[])key);
    }

    protected String[] getConfigLocations() {
        return new String[0];
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) throws Exception {
        ++this.loadCount;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading context for: " + StringUtils.arrayToCommaDelimitedString((Object[])locations)));
        }
        return new ClassPathXmlApplicationContext(locations);
    }

    public final int getLoadCount() {
        return this.loadCount;
    }
}

