/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class SubscriptionMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final MessageSendingOperations<String> messagingTemplate;

    public SubscriptionMethodReturnValueHandler(MessageSendingOperations<String> messagingTemplate) {
        Assert.notNull(messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(SubscribeMapping.class) != null && returnType.getMethodAnnotation(SendTo.class) == null && returnType.getMethodAnnotation(SendToUser.class) == null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        if (returnValue == null) {
            return;
        }
        SimpMessageHeaderAccessor inputHeaders = SimpMessageHeaderAccessor.wrap(message);
        String sessionId = inputHeaders.getSessionId();
        String subscriptionId = inputHeaders.getSubscriptionId();
        String destination = inputHeaders.getDestination();
        Assert.state((inputHeaders.getSubscriptionId() != null ? 1 : 0) != 0, (String)("No subsriptiondId in input message to method " + returnType.getMethod()));
        SubscriptionHeaderPostProcessor postProcessor = new SubscriptionHeaderPostProcessor(sessionId, subscriptionId);
        this.messagingTemplate.convertAndSend(destination, returnValue, postProcessor);
    }

    private final class SubscriptionHeaderPostProcessor
    implements MessagePostProcessor {
        private final String sessionId;
        private final String subscriptionId;

        public SubscriptionHeaderPostProcessor(String sessionId, String subscriptionId) {
            this.sessionId = sessionId;
            this.subscriptionId = subscriptionId;
        }

        @Override
        public Message<?> postProcessMessage(Message<?> message) {
            SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
            headers.setSessionId(this.sessionId);
            headers.setSubscriptionId(this.subscriptionId);
            headers.setMessageTypeIfNotSet(SimpMessageType.MESSAGE);
            return MessageBuilder.withPayload(message.getPayload()).setHeaders(headers).build();
        }
    }
}

