/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.security.Principal;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;

public class PrincipalMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return Principal.class.isAssignableFrom(paramType);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        Principal user = headers.getUser();
        if (user == null) {
            throw new MissingSessionUserException(message);
        }
        return user;
    }
}

