/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.io.Serializable;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GenericMessage<T>
implements Message<T>,
Serializable {
    private static final long serialVersionUID = 4268801052358035098L;
    private final T payload;
    private final MessageHeaders headers;

    public GenericMessage(T payload) {
        this(payload, null);
    }

    public GenericMessage(T payload, Map<String, Object> headers) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.headers = new MessageHeaders(headers);
        this.payload = payload;
    }

    @Override
    public MessageHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.payload instanceof byte[]) {
            sb.append("[Payload byte[").append(((byte[])this.payload).length).append("]]");
        } else {
            sb.append("[Payload ").append(this.payload.getClass().getSimpleName());
            sb.append(" content=").append(this.payload).append("]");
        }
        sb.append("[Headers=").append(this.headers).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.headers.hashCode() * 23 + ObjectUtils.nullSafeHashCode(this.payload);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof GenericMessage) {
            GenericMessage other = (GenericMessage)obj;
            return this.headers.getId().equals(other.headers.getId()) && this.headers.equals(other.headers) && this.payload.equals(other.payload);
        }
        return false;
    }
}

