/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;

public class PayloadArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;
    private final Validator validator;

    public PayloadArgumentResolver(MessageConverter messageConverter, Validator validator) {
        Assert.notNull((Object)messageConverter, (String)"converter must not be null");
        Assert.notNull((Object)validator, (String)"validator must not be null");
        this.converter = messageConverter;
        this.validator = validator;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return true;
    }

    @Override
    public Object resolveArgument(MethodParameter param, Message<?> message) throws Exception {
        Payload annot = (Payload)param.getParameterAnnotation(Payload.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver.");
        }
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            if (annot == null || annot.required()) {
                String paramName = this.getParameterName(param);
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(payload, paramName);
                bindingResult.addError(new ObjectError(paramName, "@Payload param is required"));
                throw new MethodArgumentNotValidException(message, param, (BindingResult)bindingResult);
            }
            return null;
        }
        Class targetClass = param.getParameterType();
        if (ClassUtils.isAssignable((Class)targetClass, payload.getClass())) {
            this.validate(message, param, payload);
            return payload;
        }
        payload = this.converter.fromMessage(message, targetClass);
        if (payload == null) {
            throw new MessageConversionException(message, "No converter found to convert to " + targetClass + ", message=" + message, null);
        }
        this.validate(message, param, payload);
        return payload;
    }

    private String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName == null ? "Arg " + param.getParameterIndex() : paramName;
    }

    protected boolean isEmptyPayload(Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            return ((byte[])payload).length == 0;
        }
        if (payload instanceof String) {
            return ((String)payload).trim().equals("");
        }
        return false;
    }

    protected void validate(Message<?> message, MethodParameter parameter, Object target) {
        if (this.validator == null) {
            return;
        }
        for (Annotation annot : parameter.getParameterAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(target, this.getParameterName(parameter));
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            if (!ObjectUtils.isEmpty((Object[])validationHints) && this.validator instanceof SmartValidator) {
                ((SmartValidator)this.validator).validate(target, (Errors)bindingResult, validationHints);
            } else {
                this.validator.validate(target, (Errors)bindingResult);
            }
            if (!bindingResult.hasErrors()) break;
            throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
        }
    }
}

