/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.AbstractMessageChannel;

public abstract class AbstractSubscribableChannel
extends AbstractMessageChannel
implements SubscribableChannel {
    @Override
    public final boolean subscribe(MessageHandler handler) {
        if (this.hasSubscription(handler)) {
            this.logger.warn((Object)("[" + this.getBeanName() + "] handler already subscribed " + handler));
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + this.getBeanName() + "] subscribing " + handler));
        }
        return this.subscribeInternal(handler);
    }

    @Override
    public final boolean unsubscribe(MessageHandler handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + this.getBeanName() + "] unsubscribing " + handler));
        }
        return this.unsubscribeInternal(handler);
    }

    public abstract boolean hasSubscription(MessageHandler var1);

    protected abstract boolean subscribeInternal(MessageHandler var1);

    protected abstract boolean unsubscribeInternal(MessageHandler var1);
}

