/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.DefaultNamingExceptionTranslator;
import org.springframework.ldap.NamingExceptionTranslator;
import org.springframework.ldap.support.DirContextOperations;
import org.springframework.ldap.support.DistinguishedName;

public class DirContextAdapter
implements DirContextOperations {
    private static final boolean ORDER_DOESNT_MATTER = false;
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$support$DirContextAdapter == null ? (class$org$springframework$ldap$support$DirContextAdapter = DirContextAdapter.class$("org.springframework.ldap.support.DirContextAdapter")) : class$org$springframework$ldap$support$DirContextAdapter));
    private final Attributes attrs;
    private DistinguishedName dn;
    private DistinguishedName base;
    private boolean updateMode = false;
    private Attributes updatedAttrs;
    private NamingExceptionTranslator exceptionTranslator;
    static /* synthetic */ Class class$org$springframework$ldap$support$DirContextAdapter;

    public DirContextAdapter() {
        this(null, null, null);
    }

    public DirContextAdapter(Name dn) {
        this(null, dn);
    }

    public DirContextAdapter(Attributes attrs, Name dn) {
        this(attrs, dn, null);
    }

    public DirContextAdapter(Attributes attrs, Name dn, Name base) {
        this.attrs = attrs != null ? attrs : new BasicAttributes(true);
        this.dn = dn != null ? new DistinguishedName(dn.toString()) : new DistinguishedName();
        this.base = base != null ? new DistinguishedName(base.toString()) : new DistinguishedName();
    }

    protected DirContextAdapter(DirContextAdapter master) {
        this.attrs = (Attributes)master.attrs.clone();
        this.dn = master.dn;
        this.updatedAttrs = (Attributes)master.updatedAttrs.clone();
        this.updateMode = master.updateMode;
    }

    protected void setUpdateMode(boolean mode) {
        this.updateMode = mode;
        if (this.updateMode) {
            this.updatedAttrs = new BasicAttributes(true);
        }
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    public String[] getNamesOfModifiedAttributes() {
        ArrayList<String> tmpList = new ArrayList<String>();
        NamingEnumeration<? extends Attribute> attributesEnumeration = this.isUpdateMode() ? this.updatedAttrs.getAll() : this.attrs.getAll();
        try {
            while (attributesEnumeration.hasMore()) {
                Attribute oneAttribute = attributesEnumeration.next();
                tmpList.add(oneAttribute.getID());
            }
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        return tmpList.toArray(new String[0]);
    }

    private void closeNamingEnumeration(NamingEnumeration enumeration) {
        try {
            if (enumeration != null) {
                enumeration.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public ModificationItem[] getModificationItems() {
        if (!this.updateMode) {
            return new ModificationItem[0];
        }
        LinkedList tmpList = new LinkedList();
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            attributesEnumeration = this.updatedAttrs.getAll();
            while (attributesEnumeration.hasMore()) {
                Attribute oneAttr = attributesEnumeration.next();
                this.collectModifications(oneAttr, tmpList);
            }
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of modifications:" + tmpList.size()));
        }
        return tmpList.toArray(new ModificationItem[tmpList.size()]);
    }

    private void collectModifications(Attribute changedAttr, List modificationList) throws NamingException {
        Attribute currentAttribute = this.attrs.get(changedAttr.getID());
        if (changedAttr.equals(currentAttribute)) {
            return;
        }
        if (currentAttribute != null && currentAttribute.size() == 1 && changedAttr.size() == 1) {
            modificationList.add(new ModificationItem(2, changedAttr));
        } else if (changedAttr.size() == 0) {
            modificationList.add(new ModificationItem(3, changedAttr));
        } else {
            LinkedList oldValues = new LinkedList();
            LinkedList newValues = new LinkedList();
            this.collectAttributeValues(oldValues, currentAttribute);
            this.collectAttributeValues(newValues, changedAttr);
            LinkedList<ModificationItem> myModifications = new LinkedList<ModificationItem>();
            Collection addedValues = CollectionUtils.subtract(newValues, oldValues);
            Collection removedValues = CollectionUtils.subtract(oldValues, newValues);
            this.collectModifications(1, changedAttr, addedValues, myModifications);
            this.collectModifications(3, changedAttr, removedValues, myModifications);
            if (myModifications.isEmpty()) {
                myModifications.add(new ModificationItem(2, changedAttr));
            }
            modificationList.addAll(myModifications);
        }
    }

    private void collectModifications(int modificationType, Attribute attr, Collection values, Collection c) {
        if (values.size() > 0) {
            BasicAttribute modificationAttribute = new BasicAttribute(attr.getID());
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                modificationAttribute.add(iter.next());
            }
            c.add(new ModificationItem(modificationType, modificationAttribute));
        }
    }

    private void collectAttributeValues(Collection valueCollection, Attribute attribute) throws NamingException {
        if (attribute == null) {
            return;
        }
        NamingEnumeration<?> attributeValues = attribute.getAll();
        while (attributeValues.hasMoreElements()) {
            Object value = attributeValues.nextElement();
            valueCollection.add(value);
        }
    }

    private boolean isChanged(String name, Object value) {
        Attribute orig = this.attrs.get(name);
        Attribute prev = this.updatedAttrs.get(name);
        if (orig == null && value == null) {
            return false;
        }
        if (orig == null || orig.size() != 1) {
            return true;
        }
        if (orig != null && value == null) {
            return true;
        }
        Object obj = null;
        try {
            obj = orig.get(0);
        }
        catch (NamingException e) {
            return true;
        }
        if (prev == null) {
            return !value.equals(obj);
        }
        Object prevObj = null;
        try {
            prevObj = prev.get(0);
        }
        catch (NamingException e) {
            return true;
        }
        return !value.equals(obj) || !value.equals(prevObj);
    }

    private boolean isEmptyAttribute(Attribute a) {
        try {
            return a == null || a.size() == 0 || a.get() == null;
        }
        catch (NamingException e) {
            return true;
        }
    }

    private boolean isChanged(String name, Object[] values, boolean orderMatters) {
        Object obj;
        int i;
        boolean emptyNewValue;
        Attribute orig = this.attrs.get(name);
        Attribute prev = this.updatedAttrs.get(name);
        boolean bl = emptyNewValue = values == null || values.length == 0;
        if (emptyNewValue) {
            return orig != null;
        }
        if (orig == null) {
            return true;
        }
        if (orig.size() != values.length) {
            return true;
        }
        if (prev != null && prev.size() != values.length) {
            return true;
        }
        try {
            for (i = 0; i < orig.size(); ++i) {
                obj = orig.get(i);
                if (!(obj instanceof String)) {
                    return true;
                }
                if (!(orderMatters ? !values[i].equals(obj) : !ArrayUtils.contains((Object[])values, (Object)obj))) continue;
                return true;
            }
        }
        catch (NamingException e) {
            return true;
        }
        if (prev != null) {
            try {
                for (i = 0; i < prev.size(); ++i) {
                    obj = prev.get(i);
                    if (!(obj instanceof String)) {
                        return true;
                    }
                    if (!(orderMatters ? !values[i].equals(obj) : !ArrayUtils.contains((Object[])values, (Object)obj))) continue;
                    return true;
                }
            }
            catch (NamingException e) {
                return true;
            }
        }
        return false;
    }

    protected final boolean exists(Attribute attr) {
        return this.exists(attr.getID());
    }

    protected final boolean exists(String attrId) {
        return this.attrs.get(attrId) != null;
    }

    public String getStringAttribute(String name) {
        return (String)this.getObjectAttribute(name);
    }

    public Object getObjectAttribute(String name) {
        Attribute oneAttr = this.attrs.get(name);
        if (oneAttr == null) {
            return null;
        }
        try {
            return oneAttr.get();
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
    }

    public void setAttributeValue(String name, Object value) {
        if (!this.updateMode && value != null) {
            this.attrs.put(name, value);
        }
        if (this.updateMode && this.isChanged(name, value)) {
            BasicAttribute attribute = new BasicAttribute(name);
            if (value != null) {
                attribute.add(value);
            }
            this.updatedAttrs.put(attribute);
        }
    }

    public void setAttributeValues(String name, Object[] values) {
        this.setAttributeValues(name, values, false);
    }

    public void setAttributeValues(String name, Object[] values, boolean orderMatters) {
        BasicAttribute a = new BasicAttribute(name, orderMatters);
        for (int i = 0; values != null && i < values.length; ++i) {
            a.add(values[i]);
        }
        if (!this.updateMode && values != null && values.length > 0) {
            this.attrs.put(a);
        }
        if (this.updateMode && this.isChanged(name, values, orderMatters)) {
            this.updatedAttrs.put(a);
        }
    }

    public void update() {
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            attributesEnumeration = this.updatedAttrs.getAll();
            while (attributesEnumeration.hasMore()) {
                Attribute a = attributesEnumeration.next();
                if (this.isEmptyAttribute(a)) {
                    this.attrs.remove(a.getID());
                    continue;
                }
                this.attrs.put(a);
            }
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        this.updatedAttrs = new BasicAttributes(true);
    }

    public String[] getStringAttributes(String name) {
        String[] attributes;
        Attribute attribute = this.attrs.get(name);
        if (attribute != null && attribute.size() > 0) {
            attributes = new String[attribute.size()];
            for (int i = 0; i < attribute.size(); ++i) {
                try {
                    attributes[i] = (String)attribute.get(i);
                    continue;
                }
                catch (NamingException e) {
                    throw this.getExceptionTranslator().translate(e);
                }
            }
        } else {
            return null;
        }
        return attributes;
    }

    public SortedSet getAttributeSortedStringSet(String name) {
        TreeSet<Object> attrSet = new TreeSet<Object>();
        Attribute attribute = this.attrs.get(name);
        if (attribute != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                try {
                    attrSet.add(attribute.get(i));
                    continue;
                }
                catch (NamingException e) {
                    throw this.getExceptionTranslator().translate(e);
                }
            }
        } else {
            return null;
        }
        return attrSet;
    }

    public void setAttribute(Attribute attribute) {
        this.attrs.put(attribute);
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (!StringUtils.isEmpty((String)name)) {
            throw new NameNotFoundException();
        }
        return (Attributes)this.attrs.clone();
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (!StringUtils.isEmpty((String)name)) {
            throw new NameNotFoundException();
        }
        BasicAttributes a = new BasicAttributes(true);
        for (int i = 0; i < attrIds.length; ++i) {
            Attribute target = this.attrs.get(attrIds[i]);
            if (target == null) continue;
            a.put(target);
        }
        return a;
    }

    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void close() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getNameInNamespace() {
        DistinguishedName result = new DistinguishedName(this.dn);
        result.prepend(this.base);
        return result.toString();
    }

    public Name getDn() {
        return this.dn;
    }

    public final void setDn(Name dn) {
        if (!this.updateMode) {
            this.dn = new DistinguishedName(dn.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(":");
        if (this.dn != null) {
            buf.append(" dn=" + this.dn);
        }
        buf.append(" {");
        try {
            NamingEnumeration<? extends Attribute> i = this.attrs.getAll();
            while (i.hasMore()) {
                Attribute attribute = i.next();
                if (attribute.size() == 1) {
                    buf.append(attribute.getID());
                    buf.append('=');
                    buf.append(attribute.get());
                } else {
                    for (int j = 0; j < attribute.size(); ++j) {
                        if (j > 0) {
                            buf.append(", ");
                        }
                        buf.append(attribute.getID());
                        buf.append('[');
                        buf.append(j);
                        buf.append("]=");
                        buf.append(attribute.get(j));
                    }
                }
                if (!i.hasMore()) continue;
                buf.append(", ");
            }
        }
        catch (NamingException e) {
            log.warn((Object)"Error in toString()");
        }
        buf.append('}');
        return buf.toString();
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = new DefaultNamingExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

