/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerPlus;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.Assert;

public class SharedEntityManagerBean
extends EntityManagerFactoryAccessor
implements FactoryBean,
InitializingBean {
    private Class entityManagerInterface;
    private EntityManager shared;

    public void setEntityManagerInterface(Class entityManagerInterface) {
        Assert.notNull((Object)entityManagerInterface, (String)"entityManagerInterface must not be null");
        Assert.isAssignable(EntityManager.class, (Class)entityManagerInterface);
        this.entityManagerInterface = entityManagerInterface;
    }

    public final void afterPropertiesSet() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null) {
            throw new IllegalArgumentException("entityManagerFactory is required");
        }
        Class[] ifcs = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
            }
            ifcs = (jpaDialect = emfInfo.getJpaDialect()) != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{this.entityManagerInterface, EntityManagerPlus.class} : new Class[]{this.entityManagerInterface};
        } else {
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = EntityManager.class;
            }
            ifcs = new Class[]{this.entityManagerInterface};
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(emf, this.getJpaPropertyMap(), ifcs);
    }

    public EntityManager getObject() {
        return this.shared;
    }

    public Class getObjectType() {
        return this.entityManagerInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

