/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.config.AbstractListenerContainerParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class JmsListenerContainerParser
extends AbstractListenerContainerParser {
    private static final String CONTAINER_TYPE_ATTRIBUTE = "container-type";
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";

    JmsListenerContainerParser() {
    }

    protected BeanDefinition parseContainer(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        Integer acknowledgeMode;
        String destinationResolverBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition();
        containerDef.setSource(parserContext.extractSource((Object)containerEle));
        this.parseListenerConfiguration(listenerEle, parserContext, (BeanDefinition)containerDef);
        this.parseContainerConfiguration(containerEle, parserContext, (BeanDefinition)containerDef);
        String containerType = containerEle.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
        if ("".equals(containerType) || "default".equals(containerType)) {
            containerDef.setBeanClassName("org.springframework.jms.listener.DefaultMessageListenerContainer");
        } else if ("default102".equals(containerType)) {
            containerDef.setBeanClassName("org.springframework.jms.listener.DefaultMessageListenerContainer102");
        } else if ("simple".equals(containerType)) {
            containerDef.setBeanClassName("org.springframework.jms.listener.SimpleMessageListenerContainer");
        } else if ("simple102".equals(containerType)) {
            containerDef.setBeanClassName("org.springframework.jms.listener.SimpleMessageListenerContainer102");
        } else {
            parserContext.getReaderContext().error("Invalid 'container-type' attribute: only \"default(102)\" and \"simple(102)\" supported.", (Object)containerEle);
        }
        String connectionFactoryBeanName = "connectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", (Object)containerEle);
        }
        containerDef.getPropertyValues().addPropertyValue("connectionFactory", (Object)new RuntimeBeanReference(connectionFactoryBeanName));
        String taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE);
        if (StringUtils.hasText((String)taskExecutorBeanName)) {
            containerDef.getPropertyValues().addPropertyValue("taskExecutor", (Object)new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText((String)(destinationResolverBeanName = containerEle.getAttribute("destination-resolver")))) {
            containerDef.getPropertyValues().addPropertyValue("destinationResolver", (Object)new RuntimeBeanReference(destinationResolverBeanName));
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            if (acknowledgeMode == 0) {
                containerDef.getPropertyValues().addPropertyValue("sessionTransacted", (Object)Boolean.TRUE);
            } else {
                containerDef.getPropertyValues().addPropertyValue("sessionAcknowledgeMode", (Object)acknowledgeMode);
            }
        }
        if (StringUtils.hasText((String)(transactionManagerBeanName = containerEle.getAttribute("transaction-manager")))) {
            if (containerType.startsWith("simple")) {
                parserContext.getReaderContext().error("'transaction-manager' attribute not supported for listener container of type \"simple\".", (Object)containerEle);
            }
            containerDef.getPropertyValues().addPropertyValue("transactionManager", (Object)new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText((String)(concurrency = containerEle.getAttribute("concurrency")))) {
            if (containerType.startsWith("default")) {
                containerDef.getPropertyValues().addPropertyValue("maxConcurrentConsumers", (Object)new Integer(concurrency));
            } else {
                containerDef.getPropertyValues().addPropertyValue("concurrentConsumers", (Object)new Integer(concurrency));
            }
        }
        if (StringUtils.hasText((String)(prefetch = containerEle.getAttribute("prefetch"))) && containerType.startsWith("default")) {
            containerDef.getPropertyValues().addPropertyValue("maxMessagesPerTask", (Object)new Integer(prefetch));
        }
        return containerDef;
    }

    protected boolean indicatesPubSub(BeanDefinition containerDef) {
        return this.indicatesPubSubConfig(containerDef);
    }

    protected boolean indicatesJms102(BeanDefinition containerDef) {
        return containerDef.getBeanClassName().endsWith("102");
    }
}

