/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.connection.SmartConnectionFactory;
import org.springframework.jms.connection.SynchedLocalTransactionFailedException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jms$connection$ConnectionFactoryUtils == null ? (class$org$springframework$jms$connection$ConnectionFactoryUtils = ConnectionFactoryUtils.class$("org.springframework.jms.connection.ConnectionFactoryUtils")) : class$org$springframework$jms$connection$ConnectionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$jms$connection$ConnectionFactoryUtils;
    static /* synthetic */ Class class$javax$jms$Session;
    static /* synthetic */ Class class$javax$jms$QueueSession;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicSession;
    static /* synthetic */ Class class$javax$jms$TopicConnection;

    public static void releaseConnection(Connection con, ConnectionFactory cf, boolean started) {
        if (con == null) {
            return;
        }
        if (started && cf instanceof SmartConnectionFactory && ((SmartConnectionFactory)cf).shouldStop(con)) {
            try {
                con.stop();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not stop JMS Connection before closing it", ex);
            }
        }
        try {
            con.close();
        }
        catch (Throwable ex) {
            logger.debug((Object)"Could not close JMS Connection", ex);
        }
    }

    public static boolean isSessionTransactional(Session session, ConnectionFactory cf) {
        if (session == null || cf == null) {
            return false;
        }
        JmsResourceHolder resourceHolder = (JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)cf));
        return resourceHolder != null && resourceHolder.containsSession(session);
    }

    public static Session getTransactionalSession(final ConnectionFactory cf, final Connection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$Session == null ? (class$javax$jms$Session = ConnectionFactoryUtils.class$("javax.jms.Session")) : class$javax$jms$Session, existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection();
            }

            public Connection createConnection() throws JMSException {
                return cf.createConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return con.createSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        }, true);
    }

    public static QueueSession getTransactionalQueueSession(final QueueConnectionFactory cf, final QueueConnection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return (QueueSession)ConnectionFactoryUtils.doGetTransactionalSession((ConnectionFactory)cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = ConnectionFactoryUtils.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession, (Connection)existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection(class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = ConnectionFactoryUtils.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
            }

            public Connection createConnection() throws JMSException {
                return cf.createQueueConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((QueueConnection)con).createQueueSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        }, true);
    }

    public static TopicSession getTransactionalTopicSession(final TopicConnectionFactory cf, final TopicConnection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return (TopicSession)ConnectionFactoryUtils.doGetTransactionalSession((ConnectionFactory)cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = ConnectionFactoryUtils.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession, (Connection)existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection(class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = ConnectionFactoryUtils.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection);
            }

            public Connection createConnection() throws JMSException {
                return cf.createTopicConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((TopicConnection)con).createTopicSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        }, true);
    }

    public static Session doGetTransactionalSession(ConnectionFactory connectionFactory, ResourceFactory resourceFactory) throws JMSException {
        return ConnectionFactoryUtils.doGetTransactionalSession(connectionFactory, resourceFactory, true);
    }

    public static Session doGetTransactionalSession(ConnectionFactory connectionFactory, ResourceFactory resourceFactory, boolean startConnection) throws JMSException {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        Assert.notNull((Object)resourceFactory, (String)"ResourceFactory must not be null");
        JmsResourceHolder resourceHolder = (JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        if (resourceHolder != null) {
            Session session = resourceFactory.getSession(resourceHolder);
            if (session != null) {
                Connection con;
                if (startConnection && (con = resourceFactory.getConnection(resourceHolder)) != null) {
                    con.start();
                }
                return session;
            }
            if (resourceHolder.isFrozen()) {
                return null;
            }
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        JmsResourceHolder resourceHolderToUse = resourceHolder;
        if (resourceHolderToUse == null) {
            resourceHolderToUse = new JmsResourceHolder(connectionFactory);
        }
        Connection con = resourceFactory.getConnection(resourceHolderToUse);
        Session session = null;
        try {
            boolean isExistingCon;
            boolean bl = isExistingCon = con != null;
            if (!isExistingCon) {
                con = resourceFactory.createConnection();
                resourceHolderToUse.addConnection(con);
            }
            session = resourceFactory.createSession(con);
            resourceHolderToUse.addSession(session, con);
            if (startConnection) {
                con.start();
            }
        }
        catch (JMSException ex) {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (resourceHolderToUse != resourceHolder) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JmsResourceSynchronization(connectionFactory, resourceHolderToUse, resourceFactory.isSynchedLocalTransactionAllowed()));
            resourceHolderToUse.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.bindResource((Object)connectionFactory, (Object)((Object)resourceHolderToUse));
        }
        return session;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JmsResourceSynchronization
    extends TransactionSynchronizationAdapter {
        private final Object resourceKey;
        private final JmsResourceHolder resourceHolder;
        private final boolean transacted;
        private boolean holderActive = true;

        public JmsResourceSynchronization(Object resourceKey, JmsResourceHolder resourceHolder, boolean transacted) {
            this.resourceKey = resourceKey;
            this.resourceHolder = resourceHolder;
            this.transacted = transacted;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.resourceKey);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.resourceKey, (Object)((Object)this.resourceHolder));
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.resourceKey);
            this.holderActive = false;
            if (!this.transacted) {
                this.resourceHolder.closeAll();
            }
        }

        public void afterCommit() {
            if (this.transacted) {
                try {
                    this.resourceHolder.commitAll();
                }
                catch (JMSException ex) {
                    throw new SynchedLocalTransactionFailedException("Local JMS transaction failed to commit", ex);
                }
            }
        }

        public void afterCompletion(int status) {
            if (this.transacted) {
                this.resourceHolder.closeAll();
            }
        }
    }

    public static interface ResourceFactory {
        public Session getSession(JmsResourceHolder var1);

        public Connection getConnection(JmsResourceHolder var1);

        public Connection createConnection() throws JMSException;

        public Session createSession(Connection var1) throws JMSException;

        public boolean isSynchedLocalTransactionAllowed();
    }
}

