/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class DefaultMessageListenerContainer102
extends DefaultMessageListenerContainer {
    protected Connection createConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createTopicSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
        }
        return ((QueueConnection)con).createQueueSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.getDurableSubscriptionName() != null) {
                return ((TopicSession)session).createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return ((TopicSession)session).createSubscriber((Topic)destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return ((QueueSession)session).createReceiver((Queue)destination, this.getMessageSelector());
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return this.getSessionAcknowledgeMode() == 2;
    }
}

