/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

public class MessageListenerAdapter102
extends MessageListenerAdapter {
    public MessageListenerAdapter102() {
    }

    public MessageListenerAdapter102(Object delegate) {
        super(delegate);
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter102());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendResponse(Session session, Destination destination, Message response) throws JMSException {
        TopicPublisher producer = null;
        try {
            if (destination instanceof Topic) {
                producer = ((TopicSession)session).createPublisher((Topic)destination);
                this.postProcessProducer((MessageProducer)producer, response);
                producer.publish(response);
            } else {
                producer = ((QueueSession)session).createSender((Queue)destination);
                this.postProcessProducer((MessageProducer)producer, response);
                ((QueueSender)producer).send(response);
            }
            if (producer == null) return;
        }
        catch (Throwable throwable) {
            if (producer == null) throw throwable;
            JmsUtils.closeMessageProducer(producer);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)producer);
    }
}

