/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.BatchUpdateException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLExceptionSubclassTranslator
extends AbstractFallbackSQLExceptionTranslator {
    public SQLExceptionSubclassTranslator() {
        this.setFallbackTranslator(new SQLStateSQLExceptionTranslator());
    }

    @Override
    protected @Nullable DataAccessException doTranslate(String task, @Nullable String sql, SQLException ex) {
        SQLException sqlEx = ex;
        if (sqlEx instanceof BatchUpdateException && sqlEx.getNextException() != null) {
            sqlEx = sqlEx.getNextException();
        }
        if (sqlEx instanceof SQLTransientException) {
            if (sqlEx instanceof SQLTransientConnectionException) {
                return new TransientDataAccessResourceException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLTransactionRollbackException) {
                if (SQLStateSQLExceptionTranslator.indicatesCannotAcquireLock(sqlEx.getSQLState())) {
                    return new CannotAcquireLockException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
                }
                return new PessimisticLockingFailureException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLTimeoutException) {
                return new QueryTimeoutException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
        } else if (sqlEx instanceof SQLNonTransientException) {
            if (sqlEx instanceof SQLNonTransientConnectionException) {
                return new DataAccessResourceFailureException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLDataException) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLIntegrityConstraintViolationException) {
                if (SQLStateSQLExceptionTranslator.indicatesDuplicateKey(sqlEx.getSQLState(), sqlEx.getErrorCode())) {
                    return new DuplicateKeyException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
                }
                return new DataIntegrityViolationException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLInvalidAuthorizationSpecException) {
                return new PermissionDeniedDataAccessException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
            if (sqlEx instanceof SQLSyntaxErrorException) {
                return new BadSqlGrammarException(task, sql != null ? sql : "", sqlEx);
            }
            if (sqlEx instanceof SQLFeatureNotSupportedException) {
                return new InvalidDataAccessApiUsageException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
            }
        } else if (sqlEx instanceof SQLRecoverableException) {
            return new RecoverableDataAccessException(this.buildMessage(task, sql, sqlEx), (Throwable)sqlEx);
        }
        return null;
    }
}

