/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class ResourceDatabasePopulator
implements DatabasePopulator {
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private String separator = ";";
    private String commentPrefix = "--";
    private String blockCommentStartDelimiter = "/*";
    private String blockCommentEndDelimiter = "*/";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public ResourceDatabasePopulator() {
    }

    public ResourceDatabasePopulator(Resource ... scripts) {
        this();
        this.scripts = Arrays.asList(scripts);
    }

    public ResourceDatabasePopulator(boolean continueOnError, boolean ignoreFailedDrops, String sqlScriptEncoding, Resource ... scripts) {
        this(scripts);
        this.continueOnError = continueOnError;
        this.ignoreFailedDrops = ignoreFailedDrops;
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void addScript(Resource script) {
        this.scripts.add(script);
    }

    public void addScripts(Resource ... scripts) {
        this.scripts.addAll(Arrays.asList(scripts));
    }

    public void setScripts(Resource ... scripts) {
        this.scripts = Arrays.asList(scripts);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setBlockCommentStartDelimiter(String blockCommentStartDelimiter) {
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
    }

    public void setBlockCommentEndDelimiter(String blockCommentEndDelimiter) {
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws ScriptException {
        for (Resource script : this.scripts) {
            ScriptUtils.executeSqlScript(connection, this.encodeScript(script), this.continueOnError, this.ignoreFailedDrops, this.commentPrefix, this.separator, this.blockCommentStartDelimiter, this.blockCommentEndDelimiter);
        }
    }

    private EncodedResource encodeScript(Resource script) {
        return new EncodedResource(script, this.sqlScriptEncoding);
    }
}

