/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class WebSphereNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_ADAPTER_CONNECTION_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private static final String CONNECTION_PROXY_NAME_4 = "com.ibm.ejs.cm.proxy.ConnectionProxy";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class webSphere5ConnectionClass;
    private Class webSphere4ConnectionClass;
    private Method webSphere5NativeConnectionMethod;
    private Method webSphere4PhysicalConnectionMethod;

    public WebSphereNativeJdbcExtractor() {
        try {
            this.logger.debug((Object)"Trying WebSphere 5 Connection: com.ibm.ws.rsadapter.jdbc.WSJdbcConnection");
            this.webSphere5ConnectionClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_CONNECTION_NAME_5);
            Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME_5);
            this.webSphere5NativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.webSphere5ConnectionClass);
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Could not find WebSphere 5 connection pool classes", (Throwable)ex);
        }
        try {
            this.logger.debug((Object)"Trying WebSphere 4 Connection: com.ibm.ejs.cm.proxy.ConnectionProxy");
            this.webSphere4ConnectionClass = this.getClass().getClassLoader().loadClass(CONNECTION_PROXY_NAME_4);
            this.webSphere4PhysicalConnectionMethod = this.webSphere4ConnectionClass.getMethod("getPhysicalConnection", null);
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Could not find WebSphere 4 connection pool classes", (Throwable)ex);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.webSphere5ConnectionClass != null && this.webSphere5ConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeMethod((Method)this.webSphere5NativeConnectionMethod, null, (Object[])new Object[]{con});
        }
        if (this.webSphere4ConnectionClass != null && this.webSphere4ConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeMethod((Method)this.webSphere4PhysicalConnectionMethod, (Object)con);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connection [" + con + "] is not a WebSphere 5/4 connection, returning as-is"));
        }
        return con;
    }
}

