/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.engine.SessionImplementor;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringSessionSynchronization
extends TransactionSynchronizationAdapter
implements Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final SQLExceptionTranslator jdbcExceptionTranslator;
    private final boolean newSession;
    private boolean hibernateTransactionCompletion = false;
    private Transaction jtaTransaction;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
        this.newSession = newSession;
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            this.hibernateTransactionCompletion = true;
            try {
                this.jtaTransaction = jtaTm.getTransaction();
            }
            catch (SystemException ex) {
                throw new DataAccessResourceFailureException("Could not access JTA transaction", (Throwable)ex);
            }
        }
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        if (!readOnly) {
            SessionFactoryUtils.logger.debug((Object)"Flushing Hibernate Session on transaction synchronization");
            Session session = null;
            if (this.jtaTransaction != null) {
                session = this.sessionHolder.getSession(this.jtaTransaction);
            }
            if (session == null) {
                session = this.sessionHolder.getSession();
            }
            if (!session.getFlushMode().equals(FlushMode.NEVER)) {
                try {
                    session.flush();
                }
                catch (JDBCException ex) {
                    if (this.jdbcExceptionTranslator != null) {
                        throw this.jdbcExceptionTranslator.translate("Hibernate transaction synchronization: " + ex.getMessage(), null, ex.getSQLException());
                    }
                    throw new HibernateJdbcException(ex);
                }
                catch (HibernateException ex) {
                    throw SessionFactoryUtils.convertHibernateAccessException(ex);
                }
            }
        }
    }

    public void beforeCompletion() {
        Session session;
        if (this.jtaTransaction != null && (session = this.sessionHolder.removeSession(this.jtaTransaction)) != null) {
            if (this.sessionHolder.isEmpty()) {
                if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                }
                this.holderActive = false;
            }
            if (session != this.sessionHolder.getSession()) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            return;
        }
        if (this.newSession) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.holderActive = false;
            if (this.hibernateTransactionCompletion) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
            }
        } else if (this.sessionHolder.getPreviousFlushMode() != null) {
            this.sessionHolder.getSession().setFlushMode(this.sessionHolder.getPreviousFlushMode());
        }
    }

    public void afterCompletion(int status) {
        if (!this.hibernateTransactionCompletion || !this.newSession) {
            Session session = this.sessionHolder.getSession();
            if (session instanceof SessionImplementor) {
                ((SessionImplementor)session).afterTransactionCompletion(status == 0);
            }
            if (this.newSession) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            }
        }
        if (!this.newSession && status != 0) {
            this.sessionHolder.getSession().clear();
        }
        if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

