/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.config.TxNamespaceUtils;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TxAdviceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ATTRIBUTES = "attributes";
    private static final String TIMEOUT = "timeout";
    private static final String READ_ONLY = "read-only";
    private static final String NAME_MAP = "nameMap";
    private static final String PROPAGATION = "propagation";
    private static final String ISOLATION = "isolation";
    private static final String ROLLBACK_FOR = "rollback-for";
    private static final String NO_ROLLBACK_FOR = "no-rollback-for";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    TxAdviceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyReference(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, element.getAttribute("transaction-manager"));
        List txAttributes = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTES);
        if (txAttributes.size() > 1) {
            throw new IllegalStateException("Element 'attributes' is allowed at most once inside element 'advice'");
        }
        if (txAttributes.size() == 1) {
            Element attributeSourceElement = (Element)txAttributes.get(0);
            RootBeanDefinition attributeSourceDefinition = this.parseAttributeSource(attributeSourceElement, parserContext);
            builder.addPropertyValue("transactionAttributeSource", (Object)attributeSourceDefinition);
        } else {
            Class sourceClass = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
            builder.addPropertyValue("transactionAttributeSource", (Object)new RootBeanDefinition(sourceClass));
        }
    }

    private RootBeanDefinition parseAttributeSource(Element attributesElement, ParserContext parserContext) {
        List methods = DomUtils.getChildElementsByTagName((Element)attributesElement, (String)"method");
        HashMap<String, RuleBasedTransactionAttribute> transactionAttributeMap = new HashMap<String, RuleBasedTransactionAttribute>(methods.size());
        for (int i = 0; i < methods.size(); ++i) {
            Element methodElement = (Element)methods.get(i);
            String name = methodElement.getAttribute("name");
            RuleBasedTransactionAttribute attribute = new RuleBasedTransactionAttribute();
            attribute.setPropagationBehaviorName("PROPAGATION_" + methodElement.getAttribute(PROPAGATION));
            attribute.setIsolationLevelName("ISOLATION_" + methodElement.getAttribute(ISOLATION));
            attribute.setTimeout(Integer.parseInt(methodElement.getAttribute(TIMEOUT)));
            attribute.setReadOnly(Boolean.valueOf(methodElement.getAttribute(READ_ONLY)));
            LinkedList rollbackRules = new LinkedList();
            if (methodElement.hasAttribute(ROLLBACK_FOR)) {
                String rollbackForValue = methodElement.getAttribute(ROLLBACK_FOR);
                this.addRollbackRuleAttributesTo(rollbackRules, rollbackForValue);
            }
            if (methodElement.hasAttribute(NO_ROLLBACK_FOR)) {
                String noRollbackForValue = methodElement.getAttribute(NO_ROLLBACK_FOR);
                this.addNoRollbackRuleAttributesTo(rollbackRules, noRollbackForValue);
            }
            attribute.setRollbackRules(rollbackRules);
            transactionAttributeMap.put(name, attribute);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource);
        attributeSourceDefinition.setSource(parserContext.extractSource((Object)attributesElement));
        attributeSourceDefinition.getPropertyValues().addPropertyValue(NAME_MAP, transactionAttributeMap);
        return attributeSourceDefinition;
    }

    private void addRollbackRuleAttributesTo(List rollbackRules, String rollbackForValue) {
        String[] exceptionTypeNames = StringUtils.commaDelimitedListToStringArray((String)rollbackForValue);
        for (int i = 0; i < exceptionTypeNames.length; ++i) {
            rollbackRules.add(new RollbackRuleAttribute(StringUtils.trimWhitespace((String)exceptionTypeNames[i])));
        }
    }

    private void addNoRollbackRuleAttributesTo(List rollbackRules, String noRollbackForValue) {
        String[] exceptionTypeNames = StringUtils.commaDelimitedListToStringArray((String)noRollbackForValue);
        for (int i = 0; i < exceptionTypeNames.length; ++i) {
            rollbackRules.add(new NoRollbackRuleAttribute(StringUtils.trimWhitespace((String)exceptionTypeNames[i])));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

