/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionEvaluator;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportRegistry;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.ParserStrategyUtils;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySourceRegistry;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.io.support.PropertySourceProcessor;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class ConfigurationClassParser {
    private static final Predicate<String> DEFAULT_EXCLUSION_FILTER = className -> className.startsWith("java.lang.annotation.") || className.startsWith("org.springframework.stereotype.");
    private static final Predicate<Condition> REGISTER_BEAN_CONDITION_FILTER = condition -> {
        ConfigurationCondition configurationCondition;
        return condition instanceof ConfigurationCondition && ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN.equals((Object)(configurationCondition = (ConfigurationCondition)condition).getConfigurationPhase());
    };
    private static final Comparator<DeferredImportSelectorHolder> DEFERRED_IMPORT_COMPARATOR = (o1, o2) -> AnnotationAwareOrderComparator.INSTANCE.compare((Object)o1.getImportSelector(), (Object)o2.getImportSelector());
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final @Nullable PropertySourceRegistry propertySourceRegistry;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;
    private final ConditionEvaluator conditionEvaluator;
    private final Map<ConfigurationClass, ConfigurationClass> configurationClasses = new LinkedHashMap<ConfigurationClass, ConfigurationClass>();
    private final MultiValueMap<String, ConfigurationClass> knownSuperclasses = new LinkedMultiValueMap();
    private final ImportStack importStack = new ImportStack();
    private final DeferredImportSelectorHandler deferredImportSelectorHandler = new DeferredImportSelectorHandler();
    private final SourceClass objectSourceClass = new SourceClass(Object.class);

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment2, ResourceLoader resourceLoader, BeanNameGenerator componentScanBeanNameGenerator, BeanDefinitionRegistry registry) {
        PropertySourceRegistry propertySourceRegistry;
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment2;
        this.resourceLoader = resourceLoader;
        Environment environment3 = this.environment;
        if (environment3 instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment ce = (ConfigurableEnvironment)environment3;
            propertySourceRegistry = new PropertySourceRegistry(new PropertySourceProcessor(ce, this.resourceLoader));
        } else {
            propertySourceRegistry = null;
        }
        this.propertySourceRegistry = propertySourceRegistry;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(environment2, resourceLoader, componentScanBeanNameGenerator, registry);
        this.conditionEvaluator = new ConditionEvaluator(registry, environment2, resourceLoader);
    }

    public void parse(Set<BeanDefinitionHolder> configCandidates) {
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                AbstractBeanDefinition abstractBeanDef;
                if (bd instanceof AnnotatedBeanDefinition) {
                    AnnotatedBeanDefinition annotatedBeanDef = (AnnotatedBeanDefinition)bd;
                    this.parse(annotatedBeanDef, holder.getBeanName());
                    continue;
                }
                if (bd instanceof AbstractBeanDefinition && (abstractBeanDef = (AbstractBeanDefinition)bd).hasBeanClass()) {
                    this.parse(abstractBeanDef.getBeanClass(), holder.getBeanName());
                    continue;
                }
                this.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to parse configuration class [" + bd.getBeanClassName() + "]", ex);
            }
        }
        this.deferredImportSelectorHandler.process();
    }

    private void parse(AnnotatedBeanDefinition beanDef, String beanName) {
        this.processConfigurationClass(new ConfigurationClass(beanDef.getMetadata(), beanName, beanDef instanceof ScannedGenericBeanDefinition), DEFAULT_EXCLUSION_FILTER);
    }

    private void parse(Class<?> clazz, String beanName) {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName), DEFAULT_EXCLUSION_FILTER);
    }

    final void parse(@Nullable String className, String beanName) throws IOException {
        Assert.notNull((Object)className, (String)"No bean class name for configuration class bean definition");
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName), DEFAULT_EXCLUSION_FILTER);
    }

    void validate() {
        for (ConfigurationClass configClass : this.configurationClasses.keySet()) {
            configClass.validate(this.problemReporter);
        }
    }

    Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses.keySet();
    }

    List<PropertySourceDescriptor> getPropertySourceDescriptors() {
        return this.propertySourceRegistry != null ? this.propertySourceRegistry.getDescriptors() : Collections.emptyList();
    }

    ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    protected void processConfigurationClass(ConfigurationClass configClass, Predicate<String> filter) {
        if (this.conditionEvaluator.shouldSkip((AnnotatedTypeMetadata)configClass.getMetadata(), ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION)) {
            return;
        }
        ConfigurationClass existingClass = this.configurationClasses.get(configClass);
        if (existingClass != null) {
            if (configClass.isImported()) {
                if (existingClass.isImported()) {
                    existingClass.mergeImportedBy(configClass);
                }
                return;
            }
            if (configClass.isScanned()) {
                String beanName = configClass.getBeanName();
                if (StringUtils.hasLength((String)beanName) && this.registry.containsBeanDefinition(beanName)) {
                    this.registry.removeBeanDefinition(beanName);
                }
                return;
            }
            this.configurationClasses.remove(configClass);
            this.removeKnownSuperclass(configClass.getMetadata().getClassName(), false);
        }
        SourceClass sourceClass = null;
        try {
            sourceClass = this.asSourceClass(configClass, filter);
            while ((sourceClass = this.doProcessConfigurationClass(configClass, sourceClass, filter)) != null) {
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure while processing configuration class [" + String.valueOf(sourceClass) + "]", (Throwable)ex);
        }
        this.configurationClasses.put(configClass, configClass);
    }

    /*
     * WARNING - void declaration
     */
    protected final @Nullable SourceClass doProcessConfigurationClass(ConfigurationClass configClass, SourceClass sourceClass, Predicate<String> filter) throws IOException {
        String superclass;
        String[] scannedBeanDefinitions;
        if (configClass.getMetadata().isAnnotated(Component.class.getName())) {
            this.processMemberClasses(configClass, sourceClass, filter);
        }
        for (AnnotationAttributes propertySource : AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), PropertySource.class, PropertySources.class, true)) {
            if (this.propertySourceRegistry != null) {
                this.propertySourceRegistry.processPropertySource(propertySource);
                continue;
            }
            this.logger.info((Object)("Ignoring @PropertySource annotation on [" + sourceClass.getMetadata().getClassName() + "]. Reason: Environment must implement ConfigurableEnvironment"));
        }
        Set<AnnotationAttributes> componentScans = AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), ComponentScan.class, ComponentScans.class, MergedAnnotation::isDirectlyPresent);
        if (componentScans.isEmpty()) {
            componentScans = AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), ComponentScan.class, ComponentScans.class, MergedAnnotation::isMetaPresent);
        }
        if (!componentScans.isEmpty()) {
            List<Condition> registerBeanConditions = this.collectRegisterBeanConditions(configClass);
            if (!registerBeanConditions.isEmpty()) {
                throw new ApplicationContextException("Component scan for configuration class [%s] could not be used with conditions in REGISTER_BEAN phase: %s".formatted(configClass.getMetadata().getClassName(), registerBeanConditions));
            }
            for (AnnotationAttributes componentScan : componentScans) {
                scannedBeanDefinitions = this.componentScanParser.parse(componentScan, sourceClass.getMetadata().getClassName());
                for (BeanDefinitionHolder beanDefinitionHolder : scannedBeanDefinitions) {
                    BeanDefinition bdCand = beanDefinitionHolder.getBeanDefinition().getOriginatingBeanDefinition();
                    if (bdCand == null) {
                        bdCand = beanDefinitionHolder.getBeanDefinition();
                    }
                    if (!ConfigurationClassUtils.checkConfigurationClassCandidate(bdCand, this.metadataReaderFactory)) continue;
                    this.parse(bdCand.getBeanClassName(), beanDefinitionHolder.getBeanName());
                }
            }
        }
        this.processImports(configClass, sourceClass, this.getImports(sourceClass), filter, true);
        AnnotationAttributes importResource = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)sourceClass.getMetadata(), ImportResource.class);
        if (importResource != null) {
            void var10_14;
            String[] resources = importResource.getStringArray("locations");
            Class readerClass = importResource.getClass("reader");
            scannedBeanDefinitions = resources;
            int n = scannedBeanDefinitions.length;
            boolean bl = false;
            while (var10_14 < n) {
                String resource = scannedBeanDefinitions[var10_14];
                String resolvedResource = this.environment.resolveRequiredPlaceholders(resource);
                configClass.addImportedResource(resolvedResource, readerClass);
                ++var10_14;
            }
        }
        Set<MethodMetadata> beanMethods = this.retrieveBeanMethodMetadata(sourceClass);
        for (MethodMetadata methodMetadata : beanMethods) {
            if (methodMetadata.isAnnotated("kotlin.jvm.JvmStatic") && !methodMetadata.isStatic()) continue;
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        this.processInterfaces(configClass, sourceClass);
        if (sourceClass.getMetadata().hasSuperClass() && (superclass = sourceClass.getMetadata().getSuperClassName()) != null && !superclass.startsWith("java")) {
            boolean superclassKnown = this.knownSuperclasses.containsKey((Object)superclass);
            this.knownSuperclasses.add((Object)superclass, (Object)configClass);
            if (!superclassKnown) {
                return sourceClass.getSuperClass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemberClasses(ConfigurationClass configClass, SourceClass sourceClass, Predicate<String> filter) throws IOException {
        Collection<SourceClass> memberClasses = sourceClass.getMemberClasses();
        if (!memberClasses.isEmpty()) {
            ArrayList<SourceClass> candidates = new ArrayList<SourceClass>(memberClasses.size());
            for (SourceClass memberClass : memberClasses) {
                if (!ConfigurationClassUtils.isConfigurationCandidate(memberClass.getMetadata()) || memberClass.getMetadata().getClassName().equals(configClass.getMetadata().getClassName())) continue;
                candidates.add(memberClass);
            }
            OrderComparator.sort(candidates);
            for (SourceClass candidate : candidates) {
                if (this.importStack.contains(configClass)) {
                    this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack));
                    continue;
                }
                this.importStack.push(configClass);
                try {
                    this.processConfigurationClass(candidate.asConfigClass(configClass), filter);
                }
                finally {
                    this.importStack.pop();
                }
            }
        }
    }

    private void processInterfaces(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        for (SourceClass ifc : sourceClass.getInterfaces()) {
            Set<MethodMetadata> beanMethods = this.retrieveBeanMethodMetadata(ifc);
            for (MethodMetadata methodMetadata : beanMethods) {
                if (methodMetadata.isAbstract()) continue;
                configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
            }
            this.processInterfaces(configClass, ifc);
        }
    }

    private Set<MethodMetadata> retrieveBeanMethodMetadata(SourceClass sourceClass) {
        AnnotationMetadata original = sourceClass.getMetadata();
        Set beanMethods = original.getAnnotatedMethods(Bean.class.getName());
        if (beanMethods.size() > 1 && original instanceof StandardAnnotationMetadata) {
            try {
                AnnotationMetadata asm = this.metadataReaderFactory.getMetadataReader(original.getClassName()).getAnnotationMetadata();
                Set asmMethods = asm.getAnnotatedMethods(Bean.class.getName());
                if (asmMethods.size() >= beanMethods.size()) {
                    LinkedHashSet candidateMethods = new LinkedHashSet(beanMethods);
                    LinkedHashSet selectedMethods = CollectionUtils.newLinkedHashSet((int)asmMethods.size());
                    block2: for (MethodMetadata asmMethod : asmMethods) {
                        Iterator it = candidateMethods.iterator();
                        while (it.hasNext()) {
                            MethodMetadata beanMethod = (MethodMetadata)it.next();
                            if (!beanMethod.getMethodName().equals(asmMethod.getMethodName())) continue;
                            selectedMethods.add(beanMethod);
                            it.remove();
                            continue block2;
                        }
                    }
                    if (selectedMethods.size() == beanMethods.size()) {
                        beanMethods = selectedMethods;
                    }
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)"Failed to read class file via ASM for determining @Bean method order", (Throwable)ex);
            }
        }
        return beanMethods;
    }

    private void removeKnownSuperclass(String removedClass, boolean replace) {
        String replacedSuperclass = null;
        ConfigurationClass replacingClass = null;
        Iterator it = this.knownSuperclasses.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!((List)entry.getValue()).removeIf(configClass -> configClass.getMetadata().getClassName().equals(removedClass))) continue;
            if (((List)entry.getValue()).isEmpty()) {
                it.remove();
                continue;
            }
            if (!replace || replacingClass != null) continue;
            replacedSuperclass = (String)entry.getKey();
            replacingClass = (ConfigurationClass)((List)entry.getValue()).get(0);
        }
        if (replacingClass != null) {
            try {
                SourceClass sourceClass = this.asSourceClass(replacingClass, DEFAULT_EXCLUSION_FILTER).getSuperClass();
                while (!sourceClass.getMetadata().getClassName().equals(replacedSuperclass) && sourceClass.getMetadata().getSuperClassName() != null) {
                    sourceClass = sourceClass.getSuperClass();
                }
                while ((sourceClass = this.doProcessConfigurationClass(replacingClass, sourceClass, DEFAULT_EXCLUSION_FILTER)) != null) {
                }
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("I/O failure while removing configuration class [" + removedClass + "]", (Throwable)ex);
            }
        }
    }

    private Set<SourceClass> getImports(SourceClass sourceClass) throws IOException {
        LinkedHashSet<SourceClass> imports = new LinkedHashSet<SourceClass>();
        this.collectImports(sourceClass, imports, new HashSet<SourceClass>());
        return imports;
    }

    private void collectImports(SourceClass sourceClass, Set<SourceClass> imports, Set<SourceClass> visited) throws IOException {
        if (visited.add(sourceClass)) {
            for (SourceClass annotation : sourceClass.getAnnotations()) {
                String annName = annotation.getMetadata().getClassName();
                if (annName.equals(Import.class.getName())) continue;
                this.collectImports(annotation, imports, visited);
            }
            imports.addAll(sourceClass.getAnnotationAttributes(Import.class.getName(), "value"));
        }
    }

    private void processImports(ConfigurationClass configClass, SourceClass currentSourceClass, Collection<SourceClass> importCandidates, Predicate<String> filter, boolean checkForCircularImports) {
        if (importCandidates.isEmpty()) {
            return;
        }
        if (checkForCircularImports && this.isChainedImportOnStack(configClass)) {
            this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack));
        } else {
            this.importStack.push(configClass);
            try {
                for (SourceClass candidate : importCandidates) {
                    Class<?> candidateClass;
                    if (candidate.isAssignable(ImportSelector.class)) {
                        candidateClass = candidate.loadClass();
                        ImportSelector selector = ParserStrategyUtils.instantiateClass(candidateClass, ImportSelector.class, this.environment, this.resourceLoader, this.registry);
                        Predicate<String> selectorFilter = selector.getExclusionFilter();
                        if (selectorFilter != null) {
                            filter = filter.or(selectorFilter);
                        }
                        if (selector instanceof DeferredImportSelector) {
                            DeferredImportSelector deferredImportSelector = (DeferredImportSelector)selector;
                            this.deferredImportSelectorHandler.handle(configClass, deferredImportSelector);
                            continue;
                        }
                        String[] importClassNames = selector.selectImports(currentSourceClass.getMetadata());
                        Collection<SourceClass> importSourceClasses = this.asSourceClasses(importClassNames, filter);
                        this.processImports(configClass, currentSourceClass, importSourceClasses, filter, false);
                        continue;
                    }
                    if (candidate.isAssignable(ImportBeanDefinitionRegistrar.class)) {
                        candidateClass = candidate.loadClass();
                        ImportBeanDefinitionRegistrar registrar = ParserStrategyUtils.instantiateClass(candidateClass, ImportBeanDefinitionRegistrar.class, this.environment, this.resourceLoader, this.registry);
                        configClass.addImportBeanDefinitionRegistrar(registrar, currentSourceClass.getMetadata());
                        continue;
                    }
                    this.importStack.registerImport(currentSourceClass.getMetadata(), candidate.getMetadata().getClassName());
                    this.processConfigurationClass(candidate.asConfigClass(configClass), filter);
                }
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configClass.getMetadata().getClassName() + "]: " + ex.getMessage(), ex);
            }
            finally {
                this.importStack.pop();
            }
        }
    }

    private boolean isChainedImportOnStack(ConfigurationClass configClass) {
        if (this.importStack.contains(configClass)) {
            String configClassName = configClass.getMetadata().getClassName();
            AnnotationMetadata importingClass = this.importStack.getImportingClassFor(configClassName);
            while (importingClass != null) {
                if (configClassName.equals(importingClass.getClassName())) {
                    return true;
                }
                importingClass = this.importStack.getImportingClassFor(importingClass.getClassName());
            }
        }
        return false;
    }

    private SourceClass asSourceClass(ConfigurationClass configurationClass, Predicate<String> filter) throws IOException {
        AnnotationMetadata metadata = configurationClass.getMetadata();
        if (metadata instanceof StandardAnnotationMetadata) {
            StandardAnnotationMetadata standardAnnotationMetadata = (StandardAnnotationMetadata)metadata;
            return this.asSourceClass(standardAnnotationMetadata.getIntrospectedClass(), filter);
        }
        return this.asSourceClass(metadata.getClassName(), filter);
    }

    SourceClass asSourceClass(@Nullable Class<?> classType, Predicate<String> filter) throws IOException {
        if (classType == null || filter.test(classType.getName())) {
            return this.objectSourceClass;
        }
        try {
            for (Annotation ann : classType.getDeclaredAnnotations()) {
                AnnotationUtils.validateAnnotation((Annotation)ann);
            }
            return new SourceClass(classType);
        }
        catch (Throwable ex) {
            return this.asSourceClass(classType.getName(), filter);
        }
    }

    private Collection<SourceClass> asSourceClasses(String[] classNames, Predicate<String> filter) throws IOException {
        ArrayList<SourceClass> annotatedClasses = new ArrayList<SourceClass>(classNames.length);
        for (String className : classNames) {
            SourceClass sourceClass = this.asSourceClass(className, filter);
            if (this.objectSourceClass == sourceClass) continue;
            annotatedClasses.add(sourceClass);
        }
        return annotatedClasses;
    }

    SourceClass asSourceClass(@Nullable String className, Predicate<String> filter) throws IOException {
        if (className == null || filter.test(className)) {
            return this.objectSourceClass;
        }
        if (className.startsWith("java")) {
            try {
                return new SourceClass(ClassUtils.forName((String)className, (ClassLoader)this.resourceLoader.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Failed to load class [" + className + "]", ex);
            }
        }
        return new SourceClass(this.metadataReaderFactory.getMetadataReader(className));
    }

    private List<Condition> collectRegisterBeanConditions(ConfigurationClass configurationClass) {
        AnnotationMetadata metadata = configurationClass.getMetadata();
        ArrayList<Condition> allConditions = new ArrayList<Condition>(this.conditionEvaluator.collectConditions((AnnotatedTypeMetadata)metadata));
        ConfigurationClass enclosingConfigurationClass = this.getEnclosingConfigurationClass(configurationClass);
        if (enclosingConfigurationClass != null) {
            allConditions.addAll(this.conditionEvaluator.collectConditions((AnnotatedTypeMetadata)enclosingConfigurationClass.getMetadata()));
        }
        return allConditions.stream().filter(REGISTER_BEAN_CONDITION_FILTER).toList();
    }

    private @Nullable ConfigurationClass getEnclosingConfigurationClass(ConfigurationClass configurationClass) {
        String enclosingClassName = configurationClass.getMetadata().getEnclosingClassName();
        if (enclosingClassName != null) {
            return configurationClass.getImportedBy().stream().filter(candidate -> enclosingClassName.equals(candidate.getMetadata().getClassName())).findFirst().orElse(null);
        }
        return null;
    }

    private class ImportStack
    extends ArrayDeque<ConfigurationClass>
    implements ImportRegistry {
        private final MultiValueMap<String, AnnotationMetadata> imports = new LinkedMultiValueMap();

        private ImportStack() {
        }

        void registerImport(AnnotationMetadata importingClass, String importedClass) {
            this.imports.add((Object)importedClass, (Object)importingClass);
        }

        @Override
        public @Nullable AnnotationMetadata getImportingClassFor(String importedClass) {
            return (AnnotationMetadata)CollectionUtils.lastElement((List)((List)this.imports.get((Object)importedClass)));
        }

        @Override
        public void removeImportingClass(String importingClass) {
            block0: for (List list : this.imports.values()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!((AnnotationMetadata)iterator.next()).getClassName().equals(importingClass)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            ConfigurationClassParser.this.removeKnownSuperclass(importingClass, true);
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner("->", "[", "]");
            for (ConfigurationClass configurationClass : this) {
                joiner.add(configurationClass.getSimpleName());
            }
            return joiner.toString();
        }
    }

    private class DeferredImportSelectorHandler {
        private @Nullable List<DeferredImportSelectorHolder> deferredImportSelectors = new ArrayList<DeferredImportSelectorHolder>();

        private DeferredImportSelectorHandler() {
        }

        void handle(ConfigurationClass configClass, DeferredImportSelector importSelector) {
            DeferredImportSelectorHolder holder = new DeferredImportSelectorHolder(configClass, importSelector);
            if (this.deferredImportSelectors == null) {
                DeferredImportSelectorGroupingHandler handler = new DeferredImportSelectorGroupingHandler();
                handler.register(holder);
                handler.processGroupImports();
            } else {
                this.deferredImportSelectors.add(holder);
            }
        }

        void process() {
            List<DeferredImportSelectorHolder> deferredImports = this.deferredImportSelectors;
            this.deferredImportSelectors = null;
            try {
                if (deferredImports != null) {
                    DeferredImportSelectorGroupingHandler handler = new DeferredImportSelectorGroupingHandler();
                    deferredImports.sort(DEFERRED_IMPORT_COMPARATOR);
                    deferredImports.forEach(handler::register);
                    handler.processGroupImports();
                }
            }
            finally {
                this.deferredImportSelectors = new ArrayList<DeferredImportSelectorHolder>();
            }
        }
    }

    private class SourceClass
    implements Ordered {
        private final Object source;
        private final AnnotationMetadata metadata;

        public SourceClass(Object source) {
            this.source = source;
            if (source instanceof Class) {
                Class sourceClass = (Class)source;
                this.metadata = AnnotationMetadata.introspect((Class)sourceClass);
            } else {
                this.metadata = ((MetadataReader)source).getAnnotationMetadata();
            }
        }

        public final AnnotationMetadata getMetadata() {
            return this.metadata;
        }

        public int getOrder() {
            Integer order = ConfigurationClassUtils.getOrder(this.metadata);
            return order != null ? order : Integer.MAX_VALUE;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            Object object = this.source;
            if (object instanceof Class) {
                Class sourceClass = (Class)object;
                return sourceClass;
            }
            String className = ((MetadataReader)this.source).getClassMetadata().getClassName();
            return ClassUtils.forName((String)className, (ClassLoader)ConfigurationClassParser.this.resourceLoader.getClassLoader());
        }

        public boolean isAssignable(Class<?> clazz) throws IOException {
            Object object = this.source;
            if (object instanceof Class) {
                Class sourceClass = (Class)object;
                return clazz.isAssignableFrom(sourceClass);
            }
            return new AssignableTypeFilter(clazz).match((MetadataReader)this.source, ConfigurationClassParser.this.metadataReaderFactory);
        }

        public ConfigurationClass asConfigClass(ConfigurationClass importedBy) {
            Object object = this.source;
            if (object instanceof Class) {
                Class sourceClass = (Class)object;
                return new ConfigurationClass(sourceClass, importedBy);
            }
            return new ConfigurationClass((MetadataReader)this.source, importedBy);
        }

        public Collection<SourceClass> getMemberClasses() throws IOException {
            Object sourceToProcess = this.source;
            if (sourceToProcess instanceof Class) {
                Class sourceClass = (Class)sourceToProcess;
                try {
                    Class<?>[] declaredClasses = sourceClass.getDeclaredClasses();
                    ArrayList<SourceClass> members = new ArrayList<SourceClass>(declaredClasses.length);
                    for (Class<?> declaredClass : declaredClasses) {
                        members.add(ConfigurationClassParser.this.asSourceClass(declaredClass, DEFAULT_EXCLUSION_FILTER));
                    }
                    return members;
                }
                catch (NoClassDefFoundError err) {
                    sourceToProcess = ConfigurationClassParser.this.metadataReaderFactory.getMetadataReader(sourceClass.getName());
                }
            }
            MetadataReader sourceReader = (MetadataReader)sourceToProcess;
            String[] memberClassNames = sourceReader.getClassMetadata().getMemberClassNames();
            ArrayList<SourceClass> members = new ArrayList<SourceClass>(memberClassNames.length);
            for (String memberClassName : memberClassNames) {
                try {
                    members.add(ConfigurationClassParser.this.asSourceClass(memberClassName, DEFAULT_EXCLUSION_FILTER));
                }
                catch (IOException ex) {
                    if (!ConfigurationClassParser.this.logger.isDebugEnabled()) continue;
                    ConfigurationClassParser.this.logger.debug((Object)("Failed to resolve member class [" + memberClassName + "] - not considering it as a configuration class candidate"));
                }
            }
            return members;
        }

        public SourceClass getSuperClass() throws IOException {
            Object object = this.source;
            if (object instanceof Class) {
                Class sourceClass = (Class)object;
                return ConfigurationClassParser.this.asSourceClass(sourceClass.getSuperclass(), DEFAULT_EXCLUSION_FILTER);
            }
            return ConfigurationClassParser.this.asSourceClass(((MetadataReader)this.source).getClassMetadata().getSuperClassName(), DEFAULT_EXCLUSION_FILTER);
        }

        public Set<SourceClass> getInterfaces() throws IOException {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            Object[] objectArray = this.source;
            if (objectArray instanceof Class) {
                Class sourceClass = (Class)objectArray;
                for (Class<?> ifcClass : sourceClass.getInterfaces()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(ifcClass, DEFAULT_EXCLUSION_FILTER));
                }
            } else {
                for (String className : this.metadata.getInterfaceNames()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(className, DEFAULT_EXCLUSION_FILTER));
                }
            }
            return result;
        }

        public Set<SourceClass> getAnnotations() {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            Annotation[] annotationArray = this.source;
            if (annotationArray instanceof Class) {
                Class sourceClass = (Class)annotationArray;
                for (Annotation ann : sourceClass.getDeclaredAnnotations()) {
                    Class<? extends Annotation> annType = ann.annotationType();
                    if (annType.getName().startsWith("java")) continue;
                    try {
                        result.add(ConfigurationClassParser.this.asSourceClass(annType, DEFAULT_EXCLUSION_FILTER));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                for (String className : this.metadata.getAnnotationTypes()) {
                    if (className.startsWith("java")) continue;
                    try {
                        result.add(this.getRelated(className));
                    }
                    catch (Throwable throwable) {}
                }
            }
            return result;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Collection<SourceClass> getAnnotationAttributes(String annType, String attribute) throws IOException {
            @Nullable Map annotationAttributes = this.metadata.getAnnotationAttributes(annType, true);
            if (annotationAttributes == null || !annotationAttributes.containsKey(attribute)) {
                return Collections.emptySet();
            }
            String[] classNames = (String[])annotationAttributes.get(attribute);
            LinkedHashSet result = CollectionUtils.newLinkedHashSet((int)classNames.length);
            for (String className : classNames) {
                result.add(this.getRelated(className));
            }
            return result;
        }

        private SourceClass getRelated(String className) throws IOException {
            Object object = this.source;
            if (object instanceof Class) {
                Class sourceClass = (Class)object;
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)sourceClass.getClassLoader());
                    return ConfigurationClassParser.this.asSourceClass(clazz, DEFAULT_EXCLUSION_FILTER);
                }
                catch (ClassNotFoundException ex) {
                    if (className.startsWith("java")) {
                        throw new IOException("Failed to load class [" + className + "]", ex);
                    }
                    return new SourceClass(ConfigurationClassParser.this.metadataReaderFactory.getMetadataReader(className));
                }
            }
            return ConfigurationClassParser.this.asSourceClass(className, DEFAULT_EXCLUSION_FILTER);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof SourceClass)) return false;
            SourceClass that = (SourceClass)other;
            if (!this.metadata.getClassName().equals(that.metadata.getClassName())) return false;
            return true;
        }

        public int hashCode() {
            return this.metadata.getClassName().hashCode();
        }

        public String toString() {
            return this.metadata.getClassName();
        }
    }

    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Deque<ConfigurationClass> importStack) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack %s", importStack.element().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.element().getResource(), (Object)attemptedImport.getMetadata()));
        }
    }

    private static class DeferredImportSelectorHolder {
        private final ConfigurationClass configurationClass;
        private final DeferredImportSelector importSelector;

        DeferredImportSelectorHolder(ConfigurationClass configClass, DeferredImportSelector selector) {
            this.configurationClass = configClass;
            this.importSelector = selector;
        }

        ConfigurationClass getConfigurationClass() {
            return this.configurationClass;
        }

        DeferredImportSelector getImportSelector() {
            return this.importSelector;
        }
    }

    private static class DefaultDeferredImportSelectorGroup
    implements DeferredImportSelector.Group {
        private final List<DeferredImportSelector.Group.Entry> imports = new ArrayList<DeferredImportSelector.Group.Entry>();

        private DefaultDeferredImportSelectorGroup() {
        }

        @Override
        public void process(AnnotationMetadata metadata, DeferredImportSelector selector) {
            for (String importClassName : selector.selectImports(metadata)) {
                this.imports.add(new DeferredImportSelector.Group.Entry(metadata, importClassName));
            }
        }

        @Override
        public Iterable<DeferredImportSelector.Group.Entry> selectImports() {
            return this.imports;
        }
    }

    private static class DeferredImportSelectorGrouping {
        private final DeferredImportSelector.Group group;
        private final List<DeferredImportSelectorHolder> deferredImports = new ArrayList<DeferredImportSelectorHolder>();

        DeferredImportSelectorGrouping(DeferredImportSelector.Group group) {
            this.group = group;
        }

        void add(DeferredImportSelectorHolder deferredImport) {
            this.deferredImports.add(deferredImport);
        }

        Iterable<DeferredImportSelector.Group.Entry> getImports() {
            for (DeferredImportSelectorHolder deferredImport : this.deferredImports) {
                this.group.process(deferredImport.getConfigurationClass().getMetadata(), deferredImport.getImportSelector());
            }
            return this.group.selectImports();
        }

        Predicate<String> getCandidateFilter() {
            Predicate<String> mergedFilter = DEFAULT_EXCLUSION_FILTER;
            for (DeferredImportSelectorHolder deferredImport : this.deferredImports) {
                Predicate<String> selectorFilter = deferredImport.getImportSelector().getExclusionFilter();
                if (selectorFilter == null) continue;
                mergedFilter = mergedFilter.or(selectorFilter);
            }
            return mergedFilter;
        }
    }

    private class DeferredImportSelectorGroupingHandler {
        private final Map<Object, DeferredImportSelectorGrouping> groupings = new LinkedHashMap<Object, DeferredImportSelectorGrouping>();
        private final Map<AnnotationMetadata, ConfigurationClass> configurationClasses = new HashMap<AnnotationMetadata, ConfigurationClass>();

        private DeferredImportSelectorGroupingHandler() {
        }

        void register(DeferredImportSelectorHolder deferredImport) {
            Class<? extends DeferredImportSelector.Group> group = deferredImport.getImportSelector().getImportGroup();
            DeferredImportSelectorGrouping grouping = this.groupings.computeIfAbsent(group != null ? group : deferredImport, key -> new DeferredImportSelectorGrouping(this.createGroup(group)));
            grouping.add(deferredImport);
            this.configurationClasses.put(deferredImport.getConfigurationClass().getMetadata(), deferredImport.getConfigurationClass());
        }

        void processGroupImports() {
            for (DeferredImportSelectorGrouping grouping : this.groupings.values()) {
                Predicate<String> filter = grouping.getCandidateFilter();
                grouping.getImports().forEach(entry -> {
                    ConfigurationClass configurationClass = this.configurationClasses.get(entry.getMetadata());
                    Assert.state((configurationClass != null ? 1 : 0) != 0, (String)"ConfigurationClass must not be null");
                    try {
                        ConfigurationClassParser.this.processImports(configurationClass, ConfigurationClassParser.this.asSourceClass(configurationClass, filter), Collections.singleton(ConfigurationClassParser.this.asSourceClass(entry.getImportClassName(), filter)), filter, false);
                    }
                    catch (BeanDefinitionStoreException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configurationClass.getMetadata().getClassName() + "]", ex);
                    }
                });
            }
        }

        private DeferredImportSelector.Group createGroup(@Nullable Class<? extends DeferredImportSelector.Group> type) {
            Class<? extends DeferredImportSelector.Group> effectiveType = type != null ? type : DefaultDeferredImportSelectorGroup.class;
            return ParserStrategyUtils.instantiateClass(effectiveType, DeferredImportSelector.Group.class, ConfigurationClassParser.this.environment, ConfigurationClassParser.this.resourceLoader, ConfigurationClassParser.this.registry);
        }
    }
}

