/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private final Supplier<Validator> validator;

    public MethodValidationInterceptor() {
        this.validator = SingletonSupplier.of(() -> Validation.buildDefaultValidatorFactory().getValidator());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validator = SingletonSupplier.of(() -> ((ValidatorFactory)validatorFactory).getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = () -> validator;
    }

    public MethodValidationInterceptor(Supplier<Validator> validator) {
        this.validator = validator;
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Set result;
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Class[] groups = this.determineValidationGroups(invocation);
        ExecutableValidator execVal = this.validator.get().forExecutables();
        Method methodToValidate = invocation.getMethod();
        Object target = invocation.getThis();
        if (target == null && invocation instanceof ProxyMethodInvocation) {
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
            target = methodInvocation.getProxy();
        }
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        catch (IllegalArgumentException ex) {
            methodToValidate = BridgeMethodResolver.findBridgedMethod((Method)ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), target.getClass()));
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        Object returnValue = invocation.proceed();
        result = execVal.validateReturnValue(target, methodToValidate, returnValue, groups);
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        return returnValue;
    }

    private boolean isFactoryBeanMetadataMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method.getName().equals("getObject");
        }
        Class<SmartFactoryBean> factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method.getName().equals("getObject") && ClassUtils.hasMethod(factoryBeanType, (Method)method);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            ProxyMethodInvocation methodInvocation;
            Object proxy;
            Object target = invocation.getThis();
            if (target != null) {
                validatedAnn = (Validated)AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            } else if (invocation instanceof ProxyMethodInvocation && AopUtils.isAopProxy((Object)(proxy = (methodInvocation = (ProxyMethodInvocation)invocation).getProxy()))) {
                Class type;
                Class[] classArray = AopProxyUtils.proxiedUserInterfaces((Object)proxy);
                int n = classArray.length;
                for (int i = 0; i < n && (validatedAnn = (Validated)AnnotationUtils.findAnnotation((Class)(type = classArray[i]), Validated.class)) == null; ++i) {
                }
            }
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }
}

